/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.templatecompiler.builder.model.JavaField;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImportImpl;
import org.richfaces.cdk.templatecompiler.builder.model.JavaModifier;
import org.richfaces.cdk.templatecompiler.el.types.ReferencedType;
import org.richfaces.cdk.templatecompiler.statements.HelperMethod;
import org.richfaces.cdk.templatecompiler.statements.StatementsContainer;
import org.richfaces.cdk.templatecompiler.statements.TemplateStatementImpl;
import org.richfaces.cdk.util.Strings;

public class FreeMarkerTemplateStatementBase
extends StatementsContainer {
    protected StatementsContainer parent;
    private String templateName;
    private final FreeMarkerRenderer renderer;
    private final Set<JavaImport> imports = Sets.newTreeSet(JavaImport.COMPARATOR);
    private final EnumSet<HelperMethod> requiredMethods = EnumSet.noneOf(HelperMethod.class);
    private final List<JavaField> fields = Lists.newArrayList();
    private boolean parsed = false;
    private String code;

    protected FreeMarkerTemplateStatementBase(FreeMarkerRenderer renderer, String templateName) {
        this.renderer = renderer;
        this.templateName = templateName + ".ftl";
    }

    @Override
    public String getCode() {
        this.parse();
        return this.code;
    }

    private void parse() {
        if (!this.parsed) {
            this.code = this.renderer.renderTemplate(this.templateName, this);
            this.parsed = true;
        }
    }

    public Object getModelItem() {
        return this;
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        this.parse();
        return Iterables.concat(super.getRequiredImports(), this.imports);
    }

    @Override
    public Iterable<JavaField> getRequiredFields() {
        this.parse();
        return Iterables.concat(super.getRequiredFields(), this.fields);
    }

    @Override
    public Iterable<HelperMethod> getRequiredMethods() {
        this.parse();
        return Iterables.concat(super.getRequiredMethods(), this.requiredMethods);
    }

    protected void addRequiredMethods(HelperMethod ... methods) {
        for (HelperMethod helperMethod : methods) {
            this.requiredMethods.add(helperMethod);
        }
    }

    protected void addRequiredMethods(Iterable<HelperMethod> methods) {
        for (HelperMethod helperMethod : methods) {
            this.requiredMethods.add(helperMethod);
        }
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName + ".ftl";
    }

    public void addConstant(String type, String name, String code) {
        JavaField field = new JavaField(new ReferencedType(type), name);
        field.addModifier(JavaModifier.PRIVATE);
        field.addModifier(JavaModifier.STATIC);
        field.addModifier(JavaModifier.FINAL);
        if (!Strings.isEmpty(code)) {
            field.setValue(new TemplateStatementImpl(code));
        }
        this.fields.add(field);
    }

    public void addImport(String name) {
        this.imports.add(new JavaImportImpl(name));
    }

    protected void addImports(Iterable<JavaImport> requiredImports) {
        Iterables.addAll(this.imports, requiredImports);
    }

    public void addRequiredMethod(String helperMethodName) {
        HelperMethod helperMethod = HelperMethod.valueOf(helperMethodName);
        this.requiredMethods.add(helperMethod);
    }
}

