/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.richfaces.cdk.attributes.Attribute;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.model.EventName;
import org.richfaces.cdk.model.Named;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.statements.FreeMarkerTemplateStatementBase;
import org.richfaces.cdk.templatecompiler.statements.PassThrough;

public class AddAttributesToScriptHashStatement
extends FreeMarkerTemplateStatementBase {
    private static final String ATTRIBUTES_FIELD_NAME = "ATTRIBUTES_FOR_SCRIPT_HASH";
    private static AtomicInteger fieldCounter = new AtomicInteger(0);
    private String fieldName;
    private String wrapper;
    private Collection<PassThrough> attributes = Lists.newArrayList();
    private Collection<PropertyBase> componentAttributes;

    @Inject
    public AddAttributesToScriptHashStatement(@TemplateModel FreeMarkerRenderer renderer) {
        super(renderer, "add-attributes-to-script-hash");
        this.fieldName = ATTRIBUTES_FIELD_NAME + fieldCounter.getAndIncrement();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Collection<PassThrough> getAttributes() {
        return this.attributes;
    }

    public String getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(String wrapper) {
        this.wrapper = wrapper;
    }

    public void setAttributes(Collection<String> attributeNames, Collection<PropertyBase> componentAttributes) {
        this.componentAttributes = componentAttributes;
        for (String attributeName : attributeNames) {
            String[] splitAttr = attributeName.split(":");
            String htmlAttributeName = splitAttr[0];
            String componentAttributeName = splitAttr.length > 1 ? splitAttr[1] : htmlAttributeName;
            PassThrough passThrough = new PassThrough();
            passThrough.name = QName.valueOf(htmlAttributeName);
            passThrough.componentAttribute = componentAttributeName;
            try {
                PropertyBase componentAttribute = this.findComponentAttribute(componentAttributeName);
                for (EventName event : componentAttribute.getEventNames()) {
                    passThrough.behaviors.add(event.getName());
                }
                passThrough.defaultValue = componentAttribute.getDefaultValue();
                passThrough.type = componentAttribute.getType().getSimpleName();
            }
            catch (NoSuchElementException e) {
                passThrough.type = Object.class.getName();
            }
            passThrough.kind = Boolean.TYPE.equals(passThrough.type) || Boolean.class.equals((Object)passThrough.type) ? Attribute.Kind.BOOLEAN : Attribute.Kind.GENERIC;
            this.attributes.add(passThrough);
        }
    }

    private PropertyBase findComponentAttribute(String name) throws NoSuchElementException {
        return (PropertyBase)Iterables.find(this.componentAttributes, (Predicate)new Named.NamePredicate(name));
    }
}

