/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.el.types;

import com.google.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.PlainClassType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.util.ArrayUtils;

public class TypeParser {
    private static final Pattern CLASS_SIGNATURE_PATTERN = Pattern.compile("^\\s*([^\\[<]+)\\s*(?:<\\s*(.*)\\s*>)?\\s*((?:\\[\\s*\\]\\s*)+)?\\s*$");
    private static final int CLASS_NAME_GROUP_IDX = 1;
    private static final int TYPE_ARGUMENTS_GROUP_IDX = 2;
    private static final int ARRAY_SIGNATURE_GROUP_IDX = 3;
    private static final int ARRAY_SIGNATURE_LENGTH = "[]".length();
    @Inject
    TypesFactory typesFactory;
    private Matcher matcher;

    public TypeParser(String typeString) {
        this.matcher = CLASS_SIGNATURE_PATTERN.matcher(typeString);
    }

    public boolean isParseable() {
        return this.matcher.matches();
    }

    public ELType[] getTypeArguments() {
        String typeArgumentsString = this.matcher.group(2);
        return this.parseTypeArgumentsString(typeArgumentsString);
    }

    private ELType[] parseTypeArgumentsString(String typeArguments) {
        if (typeArguments == null) {
            return PlainClassType.NO_TYPES;
        }
        String[] typeArgumentsSplit = typeArguments.trim().split(",");
        ELType[] types = new ELType[typeArgumentsSplit.length];
        for (int i = 0; i < typeArgumentsSplit.length; ++i) {
            types[i] = this.typesFactory.getType(typeArgumentsSplit[i]);
        }
        return types;
    }

    public boolean isArray() {
        return this.getArrayDepth() != 0 || !ArrayUtils.isEmpty(this.getTypeArguments());
    }

    public int getArrayDepth() {
        String arraySignature = this.matcher.group(3);
        int arrayDepth = 0;
        if (arraySignature != null) {
            arrayDepth = arraySignature.replaceAll("\\s+", "").length() / ARRAY_SIGNATURE_LENGTH;
        }
        return arrayDepth;
    }

    public String getClassName() {
        return this.matcher.group(1).trim();
    }
}

