/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.el.node;

import org.richfaces.cdk.templatecompiler.el.ELVisitor;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.node.AbstractTreeNode;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.NullType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;

public final class ConstantValueTreeNode
extends AbstractTreeNode {
    public static final ConstantValueTreeNode NULL_NODE = new ConstantValueTreeNode("null", NullType.INSTANCE);
    public static final ConstantValueTreeNode TRUE_NODE = new ConstantValueTreeNode("true", TypesFactory.BOOLEAN_TYPE);
    public static final ConstantValueTreeNode FALSE_NODE = new ConstantValueTreeNode("false", TypesFactory.BOOLEAN_TYPE);
    private final String value;
    private final ELType type;

    private ConstantValueTreeNode(String value, ELType type) {
        super(null);
        this.value = value;
        this.type = type;
    }

    @Override
    public void visit(StringBuilder sb, ELVisitor visitor) throws ParsingException {
        sb.append(this.value);
        visitor.setExpressionType(this.type);
        if (this.type.isNullType()) {
            visitor.setLiteral(false);
        }
    }
}

