/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.el.node;

import org.jboss.el.parser.Node;
import org.richfaces.cdk.templatecompiler.el.ELVisitor;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.node.ITreeNode;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;

public abstract class AbstractTreeNode
implements ITreeNode {
    private Node node;

    public AbstractTreeNode(Node node) {
        this.node = node;
    }

    protected String getChildOutput(int childIndex, ELVisitor visitor) throws ParsingException {
        StringBuilder sb = new StringBuilder();
        this.getChild(childIndex, visitor).visit(sb, visitor);
        return sb.toString();
    }

    protected String coerceToBoolean(String value, ELVisitor visitor) {
        return visitor.coerceToType(value, TypesFactory.BOOLEAN_TYPE);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public ITreeNode getChild(int index, ELVisitor visitor) throws ParsingException {
        Node childNode = this.getNode().jjtGetChild(index);
        if (null != childNode) {
            ITreeNode treeNode = visitor.determineNodeType(childNode);
            return treeNode;
        }
        throw new ParsingException("Child node not found of node " + this.node.getImage());
    }

    @Override
    public int getChildrenCount() {
        return this.getNode().jjtGetNumChildren();
    }

    @Override
    public abstract void visit(StringBuilder var1, ELVisitor var2) throws ParsingException;
}

