/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.builder.model;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.richfaces.cdk.templatecompiler.builder.model.Argument;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.builder.model.JavaLanguageElement;
import org.richfaces.cdk.templatecompiler.builder.model.JavaStatement;
import org.richfaces.cdk.templatecompiler.builder.model.RequireImports;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;

public class JavaMethod
extends JavaLanguageElement {
    private List<Argument> arguments = Lists.newArrayList();
    private List<ELType> exceptions = Lists.newArrayList();
    private JavaStatement methodBody;
    private ELType returnType = TypesFactory.VOID_TYPE;

    public JavaMethod(String name) {
        super(name);
    }

    public JavaMethod(String name, Collection<Argument> arguments) {
        this(name);
        this.arguments.addAll(arguments);
    }

    public JavaMethod(String name, Argument ... arguments) {
        this(name, Arrays.asList(arguments));
    }

    public JavaMethod(String name, ELType returnType, Argument ... arguments) {
        this(name);
        this.returnType = returnType;
        this.arguments.addAll(Arrays.asList(arguments));
    }

    public List<ELType> getExceptions() {
        return this.exceptions;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public JavaStatement getMethodBody() {
        return this.methodBody;
    }

    public ELType getReturnType() {
        return this.returnType;
    }

    public void setMethodBody(JavaStatement methodBody) {
        this.methodBody = methodBody;
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        Iterable exceptionsImports = Iterables.concat((Iterable)Iterables.transform(this.getExceptions(), RequireImports.IMPORTS_TRANSFORM));
        Iterable argumentsImports = Iterables.concat((Iterable)Iterables.transform(this.getArguments(), RequireImports.IMPORTS_TRANSFORM));
        Iterable imports = Iterables.concat(this.getReturnType().getRequiredImports(), (Iterable)exceptionsImports, (Iterable)argumentsImports);
        if (null != this.getMethodBody()) {
            imports = Iterables.concat((Iterable)imports, this.getMethodBody().getRequiredImports());
        }
        return imports;
    }
}

