/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.faces.application.ResourceDependencies;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.xml.namespace.QName;
import org.richfaces.cdk.CdkClassLoader;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.templatecompiler.Fragment;
import org.richfaces.cdk.templatecompiler.FragmentStore;
import org.richfaces.cdk.templatecompiler.builder.model.Argument;
import org.richfaces.cdk.templatecompiler.builder.model.JavaAnnotation;
import org.richfaces.cdk.templatecompiler.builder.model.JavaClass;
import org.richfaces.cdk.templatecompiler.builder.model.JavaField;
import org.richfaces.cdk.templatecompiler.builder.model.JavaMethod;
import org.richfaces.cdk.templatecompiler.builder.model.JavaModifier;
import org.richfaces.cdk.templatecompiler.builder.model.JavaStatement;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.model.AnyElement;
import org.richfaces.cdk.templatecompiler.model.CdkBodyElement;
import org.richfaces.cdk.templatecompiler.model.CdkCallElement;
import org.richfaces.cdk.templatecompiler.model.CdkCaseElement;
import org.richfaces.cdk.templatecompiler.model.CdkChooseElement;
import org.richfaces.cdk.templatecompiler.model.CdkDefaultElement;
import org.richfaces.cdk.templatecompiler.model.CdkForEachElement;
import org.richfaces.cdk.templatecompiler.model.CdkFragmentElement;
import org.richfaces.cdk.templatecompiler.model.CdkIfElement;
import org.richfaces.cdk.templatecompiler.model.CdkObjectElement;
import org.richfaces.cdk.templatecompiler.model.CdkOtherwiseElement;
import org.richfaces.cdk.templatecompiler.model.CdkRenderFragmentElement;
import org.richfaces.cdk.templatecompiler.model.CdkScriptObjectElement;
import org.richfaces.cdk.templatecompiler.model.CdkScriptOptionElement;
import org.richfaces.cdk.templatecompiler.model.CdkSwitchElement;
import org.richfaces.cdk.templatecompiler.model.CdkWhenElement;
import org.richfaces.cdk.templatecompiler.model.ClassImport;
import org.richfaces.cdk.templatecompiler.model.CompositeImplementation;
import org.richfaces.cdk.templatecompiler.model.CompositeInterface;
import org.richfaces.cdk.templatecompiler.model.CompositeRenderFacet;
import org.richfaces.cdk.templatecompiler.model.ResourceDependency;
import org.richfaces.cdk.templatecompiler.model.Template;
import org.richfaces.cdk.templatecompiler.model.TemplateVisitor;
import org.richfaces.cdk.templatecompiler.statements.AddAttributesToScriptHashStatement;
import org.richfaces.cdk.templatecompiler.statements.AttributesStatement;
import org.richfaces.cdk.templatecompiler.statements.CaseStatement;
import org.richfaces.cdk.templatecompiler.statements.CastComponentStatement;
import org.richfaces.cdk.templatecompiler.statements.ConstantReturnMethodBodyStatement;
import org.richfaces.cdk.templatecompiler.statements.DefineObjectStatement;
import org.richfaces.cdk.templatecompiler.statements.EncodeMethodPrefaceStatement;
import org.richfaces.cdk.templatecompiler.statements.EndElementStatement;
import org.richfaces.cdk.templatecompiler.statements.ForEachStatement;
import org.richfaces.cdk.templatecompiler.statements.HelperMethod;
import org.richfaces.cdk.templatecompiler.statements.HelperMethodFactory;
import org.richfaces.cdk.templatecompiler.statements.IfElseStatement;
import org.richfaces.cdk.templatecompiler.statements.IfStatement;
import org.richfaces.cdk.templatecompiler.statements.RenderFacetStatement;
import org.richfaces.cdk.templatecompiler.statements.RenderFragmentStatement;
import org.richfaces.cdk.templatecompiler.statements.ScriptObjectStatement;
import org.richfaces.cdk.templatecompiler.statements.ScriptOptionStatement;
import org.richfaces.cdk.templatecompiler.statements.StartElementStatement;
import org.richfaces.cdk.templatecompiler.statements.StatementsContainer;
import org.richfaces.cdk.templatecompiler.statements.SwitchStatement;
import org.richfaces.cdk.templatecompiler.statements.TemplateStatement;
import org.richfaces.cdk.templatecompiler.statements.TemplateStatementImpl;
import org.richfaces.cdk.templatecompiler.statements.WriteTextStatement;
import org.richfaces.cdk.util.Strings;

public class RendererClassVisitor
implements TemplateVisitor {
    public static final String RENDER_KIT_UTILS_CLASS_NAME = "org.richfaces.renderkit.RenderKitUtils";
    public static final String RENDERER_BASE_CLASS_NAME = "org.richfaces.renderkit.RendererBase";
    public static final String RESPONSE_WRITER_VARIABLE = "responseWriter";
    public static final String COMPONENT_VARIABLE = "component";
    public static final String COMPONENT_PARAMETER = "uiComponent";
    public static final String THIS_VARIABLE = "this";
    public static final String SUPER_VARIABLE = "super";
    public static final String FACES_CONTEXT_VARIABLE = "facesContext";
    public static final ImmutableMap<String, Object> ENCODE_METHOD_VARIABLES = ImmutableMap.builder().put((Object)"facesContextVariable", (Object)"facesContext").put((Object)"componentVariable", (Object)"component").put((Object)"responseWriterVariable", (Object)"responseWriter").put((Object)"clientIdVariable", (Object)"clientId").build();
    static final String CLIENT_ID_VARIABLE = "clientId";
    private final Logger log;
    private final Injector injector;
    private final TypesFactory typesFactory;
    private final HelperMethodFactory helperMethodFactory;
    private final CompositeInterface compositeInterface;
    private final Collection<PropertyBase> attributes;
    private StatementsContainer currentStatement;
    private JavaClass generatedClass;
    private ClassName componentBaseClass;
    private ClassName rendererSuperClass;
    private boolean isExtendingRendererBase = false;
    private Set<HelperMethod> addedHelperMethods = EnumSet.noneOf(HelperMethod.class);
    private CdkClassLoader loader;
    private FragmentStore fragmentStore;

    public RendererClassVisitor(CompositeInterface compositeInterface, Collection<PropertyBase> attributes, Logger log, Injector injector, TypesFactory typesFactory, HelperMethodFactory helperFactory, CdkClassLoader loader) {
        this.compositeInterface = compositeInterface;
        this.attributes = attributes;
        this.injector = injector;
        this.typesFactory = typesFactory;
        this.log = log;
        this.helperMethodFactory = helperFactory;
        this.loader = loader;
        this.fragmentStore = new FragmentStore();
        this.injector.injectMembers((Object)this.fragmentStore);
    }

    private void initializeJavaClass() {
        this.generatedClass = new JavaClass(this.compositeInterface.getJavaClass());
        this.generatedClass.addModifier(JavaModifier.PUBLIC);
        this.rendererSuperClass = this.compositeInterface.getBaseClass();
        if (null != this.rendererSuperClass) {
            this.generatedClass.setSuperClass(this.rendererSuperClass);
            this.isExtendingRendererBase = this.isExtendingRendererBase();
        }
        this.componentBaseClass = this.compositeInterface.getComponentBaseClass();
        if (null == this.componentBaseClass) {
            this.componentBaseClass = new ClassName(UIComponent.class.getName());
        }
        this.generatedClass.addImport(FacesContext.class);
        this.generatedClass.addImport(ResponseWriter.class);
        this.generatedClass.addImport(UIComponent.class);
        for (ClassImport classImport : this.compositeInterface.getClassImports()) {
            ArrayList importedNames = classImport.getNames();
            if (importedNames == null || importedNames.isEmpty()) {
                importedNames = Lists.newArrayList((Object[])new String[]{"*"});
            }
            for (String importedName : importedNames) {
                this.generatedClass.addImport(Strings.DOT_JOINER.join((Object)classImport.getPackage(), (Object)importedName, new Object[0]), classImport.isStatic());
            }
        }
        List<ResourceDependency> resourceDependencies = this.compositeInterface.getResourceDependencies();
        ELType dependencyType = this.typesFactory.getType((Type)((Object)javax.faces.application.ResourceDependency.class));
        if (1 == resourceDependencies.size()) {
            ResourceDependency resource = resourceDependencies.get(0);
            this.generatedClass.addAnnotation(this.createResourceAnnotation(dependencyType, resource));
        } else if (resourceDependencies.size() > 1) {
            StringBuilder resources = new StringBuilder("{");
            for (ResourceDependency resource : resourceDependencies) {
                if (resources.length() > 1) {
                    resources.append(',');
                }
                resources.append("@ResourceDependency(");
                resources.append("name=\"").append(resource.getName()).append("\",library=\"").append(resource.getLibrary()).append("\",target=\"").append(resource.getTarget()).append("\"").append(")");
            }
            resources.append("}");
            this.generatedClass.addAnnotation(new JavaAnnotation(this.typesFactory.getType((Type)((Object)ResourceDependencies.class)), resources.toString()));
            this.generatedClass.addImport(javax.faces.application.ResourceDependency.class);
        }
        this.createMethodContext();
    }

    private boolean isExtendingRendererBase() {
        try {
            Class<?> rendererSuperType = this.loader.loadClass(this.rendererSuperClass.getFullName());
            Class<?> rendererBaseType = this.loader.loadClass(RENDERER_BASE_CLASS_NAME);
            return rendererBaseType.isAssignableFrom(rendererSuperType);
        }
        catch (ClassNotFoundException e) {
            this.log.warn((CharSequence)("Could not determine if the renderer-base-class extends org.richfaces.renderkit.RendererBase: " + e.getMessage()));
            return false;
        }
    }

    private JavaAnnotation createResourceAnnotation(ELType dependencyType, ResourceDependency resource) {
        return new JavaAnnotation(dependencyType, "name=\"" + resource.getName() + "\"", "library=\"" + resource.getLibrary() + "\"", "target=\"" + resource.getTarget() + "\"");
    }

    private void addHelperMethod(HelperMethod helperMethod) {
        if (this.addedHelperMethods.add(helperMethod)) {
            JavaMethod helperJavaMethod = this.helperMethodFactory.getHelperMethod(helperMethod);
            if (helperJavaMethod.isHidden()) {
                this.generatedClass.addImports(helperJavaMethod.getRequiredImports());
            } else {
                this.generatedClass.addMethod(helperJavaMethod);
            }
            this.addHelperMethods(helperJavaMethod.getMethodBody());
        }
    }

    private void addHelperMethods(JavaStatement statement) {
        if (statement instanceof TemplateStatement) {
            TemplateStatement templateStatement = (TemplateStatement)statement;
            for (HelperMethod helper : templateStatement.getRequiredMethods()) {
                this.addHelperMethod(helper);
            }
        }
    }

    private ELType getType(Class<?> type) {
        return this.typesFactory.getType(type.getName());
    }

    private void createMethodContext() {
        this.currentStatement = new StatementsContainer();
        this.currentStatement.setVariable(FACES_CONTEXT_VARIABLE, this.getType(FacesContext.class));
        this.currentStatement.setVariable(RESPONSE_WRITER_VARIABLE, this.getType(ResponseWriter.class));
        this.currentStatement.setVariable(CLIENT_ID_VARIABLE, this.getType(String.class));
        ELType componentBaseClassType = this.typesFactory.getType(this.componentBaseClass.getName());
        this.currentStatement.setVariable(COMPONENT_VARIABLE, componentBaseClassType);
        ELType generatedClassSuperType = this.typesFactory.getType(this.generatedClass.getSuperClass().getName());
        this.currentStatement.setVariable(SUPER_VARIABLE, generatedClassSuperType);
        ELType generatedClassType = this.typesFactory.getGeneratedType(this.generatedClass.getName(), generatedClassSuperType);
        this.currentStatement.setVariable(THIS_VARIABLE, generatedClassType);
    }

    private void flushToMethod(String methodName, boolean enforce, boolean override, Collection<Argument> additionaArguments) {
        if (enforce || !this.currentStatement.isEmpty()) {
            Argument componentArgument;
            Argument facesContextArgument = new Argument(FACES_CONTEXT_VARIABLE, this.getType(FacesContext.class));
            Argument responseWriterArgument = new Argument(RESPONSE_WRITER_VARIABLE, this.getType(ResponseWriter.class));
            int statementCount = 0;
            if (null != this.compositeInterface.getComponentBaseClass()) {
                ELType type = this.typesFactory.getType(this.compositeInterface.getComponentBaseClass().getName());
                componentArgument = new Argument(COMPONENT_PARAMETER, this.getType(UIComponent.class));
                CastComponentStatement statement = this.createStatement(CastComponentStatement.class);
                statement.setType(type);
                statement.setComponentParameter(COMPONENT_PARAMETER);
                this.currentStatement.addStatement(statementCount, statement);
                ++statementCount;
            } else {
                componentArgument = new Argument(COMPONENT_VARIABLE, this.getType(UIComponent.class));
            }
            LinkedList arguments = Lists.newLinkedList();
            if (this.isExtendingRendererBase) {
                arguments.add(responseWriterArgument);
            }
            arguments.add(facesContextArgument);
            arguments.add(componentArgument);
            arguments.addAll(additionaArguments);
            JavaMethod javaMethod = new JavaMethod(methodName, arguments);
            javaMethod.addModifier(JavaModifier.PUBLIC);
            javaMethod.getExceptions().add(this.getType(IOException.class));
            if (override) {
                javaMethod.addAnnotation(new JavaAnnotation(this.getType(Override.class)));
            }
            EncodeMethodPrefaceStatement encodeMethodPreface = this.createStatement(EncodeMethodPrefaceStatement.class);
            encodeMethodPreface.setRenderResponseWriter(!this.isExtendingRendererBase);
            this.currentStatement.addStatement(statementCount, encodeMethodPreface);
            javaMethod.setMethodBody(this.currentStatement);
            this.addHelperMethods(this.currentStatement);
            for (JavaField field : this.currentStatement.getRequiredFields()) {
                this.generatedClass.addField(field);
            }
            this.generatedClass.addMethod(javaMethod);
        }
    }

    private void flushToEncodeMethod(String encodeMethodName, boolean enforce) {
        this.flushToMethod(encodeMethodName, enforce, true, Collections.EMPTY_LIST);
        this.createMethodContext();
    }

    private void createRendersChildrenMethod() {
        Boolean rendersChildren = this.compositeInterface.getRendersChildren();
        if (rendersChildren != null) {
            JavaMethod rendersChildrenMethod = new JavaMethod("getRendersChildren", TypesFactory.BOOLEAN_TYPE, new Argument[0]);
            rendersChildrenMethod.addModifier(JavaModifier.PUBLIC);
            rendersChildrenMethod.addAnnotation(new JavaAnnotation(this.getType(Override.class)));
            ConstantReturnMethodBodyStatement statement = this.createStatement(ConstantReturnMethodBodyStatement.class);
            statement.setReturnValue(Boolean.toString(this.compositeInterface.getRendersChildren()));
            rendersChildrenMethod.setMethodBody(statement);
            this.generatedClass.addMethod(rendersChildrenMethod);
        }
    }

    private <T extends TemplateStatement> T createStatement(Class<T> statementClass) {
        return (T)((TemplateStatement)this.injector.getInstance(statementClass));
    }

    protected void pushStatement(StatementsContainer container) {
        this.addStatement(container);
        this.currentStatement = container;
    }

    protected <T extends StatementsContainer> T pushStatement(Class<T> container) {
        StatementsContainer statement = (StatementsContainer)this.createStatement(container);
        this.pushStatement(statement);
        return (T)statement;
    }

    protected void popStatement() {
        this.currentStatement = this.currentStatement.getParent();
    }

    protected <T extends TemplateStatement> T addStatement(Class<T> statementClass) {
        T statement = this.createStatement(statementClass);
        this.addStatement((TemplateStatement)statement);
        return statement;
    }

    protected void addStatement(TemplateStatement statement) {
        this.currentStatement.addStatement(statement);
    }

    public JavaClass getGeneratedClass() {
        return this.generatedClass;
    }

    @Override
    public void startElement(CdkBodyElement cdkBodyElement) throws CdkException {
        if (this.isExtendingRendererBase) {
            this.flushToEncodeMethod("doEncodeBegin", false);
        } else {
            this.flushToEncodeMethod("encodeBegin", false);
        }
    }

    @Override
    public void endElement(CdkBodyElement cdkBodyElement) throws CdkException {
        if (this.isExtendingRendererBase) {
            this.flushToEncodeMethod("doEncodeChildren", cdkBodyElement.isEnforce());
        } else {
            this.flushToEncodeMethod("encodeChildren", cdkBodyElement.isEnforce());
        }
    }

    @Override
    public void startElement(AnyElement anyElement) throws CdkException {
        QName elementName = anyElement.getName();
        if (Template.isDirectiveNamespace(elementName)) {
            this.log.error((CharSequence)("Unknown directive element " + elementName));
        } else {
            StartElementStatement startElementStatement = this.addStatement(StartElementStatement.class);
            startElementStatement.setElementName(elementName);
            AttributesStatement attributesStatement = this.addStatement(AttributesStatement.class);
            attributesStatement.processAttributes(anyElement, this.attributes);
        }
    }

    @Override
    public void endElement(AnyElement anyElement) throws CdkException {
        QName elementName = anyElement.getName();
        EndElementStatement endElementStatement = this.addStatement(EndElementStatement.class);
        endElementStatement.setElementName(elementName);
    }

    @Override
    public void visitElement(String text) throws CdkException {
        String trimmedText;
        if (text != null && (trimmedText = text.trim()).length() > 0) {
            WriteTextStatement statement = this.addStatement(WriteTextStatement.class);
            statement.setExpression(trimmedText);
        }
    }

    @Override
    public void visitElement(CdkCallElement cdkCallElement) throws CdkException {
        String expression = cdkCallElement.getExpression();
        if (Strings.isEmpty(expression)) {
            expression = cdkCallElement.getBodyValue();
        }
        this.addStatement(new TemplateStatementImpl(expression + ";"));
    }

    @Override
    public void startElement(CdkIfElement cdkIfElement) {
        this.pushStatement(IfElseStatement.class);
        IfStatement ifStatement = this.pushStatement(IfStatement.class);
        ifStatement.setTest(cdkIfElement.getTest());
    }

    @Override
    public void endElement(CdkIfElement cdkIfElement) {
        this.popStatement();
        this.popStatement();
    }

    @Override
    public void startElement(CdkChooseElement cdkChooseElement) {
        this.pushStatement(IfElseStatement.class);
    }

    @Override
    public void endElement(CdkChooseElement cdkChooseElement) {
        this.popStatement();
    }

    @Override
    public void startElement(CdkWhenElement cdkWhenElement) {
        IfStatement ifStatement = this.pushStatement(IfStatement.class);
        ifStatement.setTest(cdkWhenElement.getTest());
    }

    @Override
    public void endElement(CdkWhenElement cdkWhenElement) {
        this.popStatement();
    }

    @Override
    public void startElement(CdkOtherwiseElement cdkOtherwiseElement) {
        this.pushStatement(StatementsContainer.class);
    }

    @Override
    public void endElement(CdkOtherwiseElement cdkOtherwiseElement) {
        this.popStatement();
    }

    @Override
    public void visitElement(CdkObjectElement cdkObjectElement) {
        String name = cdkObjectElement.getName();
        String value = cdkObjectElement.getValue();
        if (Strings.isEmpty(value)) {
            value = cdkObjectElement.getBodyValue();
        }
        String type = cdkObjectElement.getType();
        DefineObjectStatement statement = this.addStatement(DefineObjectStatement.class);
        statement.setObject(name, type, value, cdkObjectElement.isCast());
        this.currentStatement.setVariable(name, statement.getType());
    }

    @Override
    public void startElement(CdkForEachElement cdkForEachElement) {
        String items = cdkForEachElement.getItems();
        String var = cdkForEachElement.getVar();
        String varStatus = cdkForEachElement.getVarStatus();
        Integer begin = cdkForEachElement.getBegin();
        Integer end = cdkForEachElement.getEnd();
        Integer step = cdkForEachElement.getStep();
        ForEachStatement forEachStatement = this.pushStatement(ForEachStatement.class);
        forEachStatement.setItemsExpression(items, var, varStatus, begin, end, step);
    }

    @Override
    public void endElement(CdkForEachElement cdkForEachElement) {
        this.popStatement();
    }

    @Override
    public void startElement(CdkSwitchElement cdkSwitchElement) {
        String key = cdkSwitchElement.getKey();
        SwitchStatement switchStatement = this.pushStatement(SwitchStatement.class);
        switchStatement.setKeyExpression(key);
    }

    @Override
    public void endElement(CdkSwitchElement cdkSwitchElement) {
        this.popStatement();
    }

    @Override
    public void startElement(CdkCaseElement cdkCaseElement) {
        CaseStatement caseStatement = this.pushStatement(CaseStatement.class);
        caseStatement.setValues(cdkCaseElement.getValues());
    }

    @Override
    public void endElement(CdkCaseElement cdkCaseElement) {
        this.popStatement();
    }

    @Override
    public void startElement(CdkDefaultElement cdkDefaultElement) {
        this.pushStatement(CaseStatement.class);
    }

    @Override
    public void endElement(CdkDefaultElement cdkDefaultElement) {
        this.popStatement();
    }

    @Override
    public void preProcess(CompositeImplementation impl) {
        this.initializeJavaClass();
    }

    @Override
    public void startElement(CompositeRenderFacet compositeRenderFacetElement) throws CdkException {
        RenderFacetStatement renderFacetStatement = this.pushStatement(RenderFacetStatement.class);
        renderFacetStatement.setName(compositeRenderFacetElement.getName());
    }

    @Override
    public void endElement(CompositeRenderFacet compositeRenderFacetElement) throws CdkException {
        this.popStatement();
    }

    @Override
    public void postProcess(CompositeImplementation impl) {
        if (this.isExtendingRendererBase) {
            this.flushToEncodeMethod("doEncodeEnd", false);
        } else {
            this.flushToEncodeMethod("encodeEnd", false);
        }
        this.createRendersChildrenMethod();
    }

    @Override
    public void startElement(CdkScriptObjectElement cdkScriptObjectElement) {
        ScriptObjectStatement scriptObjectStatement = this.pushStatement(ScriptObjectStatement.class);
        scriptObjectStatement.setObject(cdkScriptObjectElement.getName(), cdkScriptObjectElement.getBase());
    }

    @Override
    public void endElement(CdkScriptObjectElement cdkScriptObjectElement) {
        this.popStatement();
    }

    private void addScriptHashAttributesPassthroughStatement(List<String> attributeNames, String wrapper) {
        if (attributeNames == null || attributeNames.isEmpty()) {
            return;
        }
        AddAttributesToScriptHashStatement statement = this.addStatement(AddAttributesToScriptHashStatement.class);
        statement.setWrapper(wrapper);
        statement.setAttributes(attributeNames, this.attributes);
    }

    private void addScriptOptionStatement(String name, String value, String defaultValue, String wrapper) {
        ScriptOptionStatement scriptOptionStatement = this.addStatement(ScriptOptionStatement.class);
        scriptOptionStatement.setName(name);
        scriptOptionStatement.setValueExpression(value);
        scriptOptionStatement.setDefaultValue(defaultValue);
        scriptOptionStatement.setWrapper(wrapper);
    }

    @Override
    public void visitElement(CdkScriptOptionElement cdkScriptOptionElement) {
        this.addScriptHashAttributesPassthroughStatement(cdkScriptOptionElement.getAttributes(), cdkScriptOptionElement.getWrapper());
        for (String variableName : cdkScriptOptionElement.getVariables()) {
            this.addScriptOptionStatement(variableName, MessageFormat.format("#'{'{0}'}'", variableName), cdkScriptOptionElement.getDefaultValue(), cdkScriptOptionElement.getWrapper());
        }
        if (!Strings.isEmpty(cdkScriptOptionElement.getName())) {
            this.addScriptOptionStatement(cdkScriptOptionElement.getName(), cdkScriptOptionElement.getValue(), cdkScriptOptionElement.getDefaultValue(), cdkScriptOptionElement.getWrapper());
        }
    }

    @Override
    public void preProcess(CdkFragmentElement fragmentElement) {
        Fragment fragment = this.fragmentStore.addFragment(fragmentElement);
        this.createMethodContext();
        for (Argument argument : fragment.getAllArguments()) {
            this.currentStatement.setVariable(argument.getName(), argument.getType());
        }
    }

    @Override
    public void postProcess(CdkFragmentElement fragmentElement) {
        Fragment fragment = this.fragmentStore.getFragment(fragmentElement.getName());
        this.flushToMethod(fragment.getMethodName(), true, false, fragment.getAllArguments());
        this.createMethodContext();
    }

    @Override
    public void visitElement(CdkRenderFragmentElement renderFragmentElement) throws CdkException {
        RenderFragmentStatement statement = this.addStatement(RenderFragmentStatement.class);
        statement.setMethodName(renderFragmentElement.getName());
        statement.setAttributes(renderFragmentElement.getAttributes());
        statement.setFragmentStore(this.fragmentStore);
        statement.setExtendingRendererBase(this.isExtendingRendererBase);
    }
}

