/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Map;
import org.richfaces.cdk.templatecompiler.Fragment;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.model.CdkFragmentElement;

public class FragmentStore {
    Map<String, Fragment> store = Maps.newHashMap();
    @Inject
    TypesFactory typesFactory;

    public Fragment getFragment(String fragmentName) {
        return this.store.get(fragmentName);
    }

    public Fragment addFragment(CdkFragmentElement fragmentElement) {
        String fragmentName = fragmentElement.getName();
        if (this.store.containsKey(fragmentName)) {
            throw new IllegalStateException("Fragment " + fragmentName + " is already defined.");
        }
        Fragment fragment = new Fragment(fragmentElement, this.typesFactory);
        this.store.put(fragmentName, fragment);
        return fragment;
    }
}

