/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.model;

import com.google.inject.Singleton;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.richfaces.cdk.model.BehaviorModel;
import org.richfaces.cdk.model.Cacheable;
import org.richfaces.cdk.model.ComponentModel;
import org.richfaces.cdk.model.ConfigExtension;
import org.richfaces.cdk.model.ConverterModel;
import org.richfaces.cdk.model.EventModel;
import org.richfaces.cdk.model.Extensible;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.FunctionModel;
import org.richfaces.cdk.model.ListenerModel;
import org.richfaces.cdk.model.Merge;
import org.richfaces.cdk.model.Mergeable;
import org.richfaces.cdk.model.ModelCollection;
import org.richfaces.cdk.model.ModelElement;
import org.richfaces.cdk.model.ModelSet;
import org.richfaces.cdk.model.RenderKitModel;
import org.richfaces.cdk.model.RendererModel;
import org.richfaces.cdk.model.Taglib;
import org.richfaces.cdk.model.Trackable;
import org.richfaces.cdk.model.ValidatorModel;
import org.richfaces.cdk.model.Visitable;
import org.richfaces.cdk.model.Visitor;
import org.richfaces.cdk.util.JavaUtils;
import org.richfaces.cdk.util.Strings;

@Singleton
public class ComponentLibrary
implements Serializable,
Extensible<ConfigExtension>,
Trackable,
Visitable,
Cacheable {
    public static final String CDK_EXTENSIONS_NAMESPACE = "http://jboss.org/schema/richfaces/cdk/extensions";
    public static final String FACES_CONFIG_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    public static final String FACES_CONFIG_SCHEMA_LOCATION = "http://java.sun.com/xml/ns/javaee/web-facesconfig_2_0.xsd";
    public static final String TAGLIB_SCHEMA_LOCATION = "http://java.sun.com/xml/ns/javaee/web-facelettaglibrary_2_0.xsd";
    private static final long serialVersionUID = -6055670836731899832L;
    private final ModelCollection<ComponentModel> components = ModelSet.create();
    private final ModelCollection<RenderKitModel> renderKits = ModelSet.create();
    private final ModelCollection<ConverterModel> converters = ModelSet.create();
    private final ModelCollection<ValidatorModel> validators = ModelSet.create();
    private final ModelCollection<ListenerModel> listeners = ModelSet.create();
    private final ModelCollection<FunctionModel> functions = ModelSet.create();
    private long lastModified = Long.MIN_VALUE;
    private final ModelCollection<EventModel> events = ModelSet.create();
    private final ModelCollection<BehaviorModel> behaviors = ModelSet.create();
    private ConfigExtension extension = new ConfigExtension();
    private String prefix;
    private Taglib taglib;
    private boolean metadataComplete;

    @Override
    public <R, D> R accept(Visitor<R, D> visitor, D data) {
        R result = visitor.visitComponentLibrary(this, data);
        result = this.renderKits.accept(result, visitor, data);
        result = this.components.accept(result, visitor, data);
        result = this.converters.accept(result, visitor, data);
        result = this.validators.accept(result, visitor, data);
        result = this.listeners.accept(result, visitor, data);
        result = this.events.accept(result, visitor, data);
        result = this.behaviors.accept(result, visitor, data);
        result = this.functions.accept(result, visitor, data);
        return result;
    }

    public RenderKitModel addRenderKit(String renderKitId) {
        FacesId renderKitType = new FacesId(renderKitId);
        RenderKitModel renderKit = this.addRenderKit(renderKitType);
        return renderKit;
    }

    public RenderKitModel addRenderKit(FacesId renderKitType) {
        RenderKitModel renderKit = this.getRenderKit(renderKitType);
        if (null == renderKit) {
            renderKit = new RenderKitModel();
            renderKit.setId(renderKitType);
            this.renderKits.add(renderKit);
        }
        return renderKit;
    }

    public ModelCollection<ComponentModel> getComponents() {
        return this.components;
    }

    public ComponentModel getComponentByRenderer(FacesId family, FacesId rendererType) {
        if (family == null) {
            return null;
        }
        for (ComponentModel component : this.components) {
            if (!family.equals(component.getFamily()) || !rendererType.equals(component.getRendererType())) continue;
            return component;
        }
        return null;
    }

    public ComponentModel getComponentByType(FacesId componentType) {
        for (ComponentModel component : this.components) {
            if (!componentType.equals(component.getId())) continue;
            return component;
        }
        return null;
    }

    public ComponentModel getComponentByFamily(FacesId family) {
        if (family == null) {
            return null;
        }
        for (ComponentModel component : this.components) {
            if (!family.equals(component.getFamily())) continue;
            return component;
        }
        return null;
    }

    public ComponentModel getComponentByFamily(String componentFamily) {
        return this.getComponentByFamily(FacesId.parseId(componentFamily));
    }

    public RendererModel getRendererByType(FacesId rendererType) {
        for (RenderKitModel renderKit : this.getRenderKits()) {
            for (RendererModel renderer : renderKit.getRenderers()) {
                if (!rendererType.equals(renderer.getId())) continue;
                return renderer;
            }
        }
        return null;
    }

    public ModelCollection<RenderKitModel> getRenderKits() {
        return this.renderKits;
    }

    public RenderKitModel getRenderKit(FacesId id) {
        if (null != id) {
            for (RenderKitModel renderKit : this.renderKits) {
                if (!id.equals(renderKit.getId())) continue;
                return renderKit;
            }
        }
        return null;
    }

    public void addRenderer(FacesId renderKitId, RendererModel rendererModel) {
        RenderKitModel renderKit = this.addRenderKit(renderKitId);
        renderKit.getRenderers().add(rendererModel);
    }

    public void addRenderer(String renderKitId, RendererModel rendererModel) {
        this.addRenderer(new FacesId(renderKitId), rendererModel);
    }

    public RendererModel getRenderer(String componentFamily, String componentType) {
        if (Strings.isEmpty(componentFamily)) {
            return null;
        }
        ArrayList<RendererModel> res = new ArrayList<RendererModel>();
        for (RenderKitModel renderKitModel : this.renderKits) {
            for (RendererModel rendererModel : renderKitModel.getRenderers()) {
                if (!componentFamily.equals(rendererModel.getFamily())) continue;
                res.add(rendererModel);
            }
        }
        if (res.size() == 0) {
            return null;
        }
        if (res.size() > 1) {
            for (RendererModel renderer : res) {
                String rendererComponentType = renderer.getComponentType();
                if (!componentType.equals(rendererComponentType)) continue;
                return renderer;
            }
        }
        return (RendererModel)res.get(0);
    }

    public ModelCollection<ConverterModel> getConverters() {
        return this.converters;
    }

    public ModelCollection<ValidatorModel> getValidators() {
        return this.validators;
    }

    public ModelCollection<BehaviorModel> getBehaviors() {
        return this.behaviors;
    }

    public ModelCollection<ListenerModel> getListeners() {
        return this.listeners;
    }

    public ModelCollection<EventModel> getEvents() {
        return this.events;
    }

    public ModelCollection<FunctionModel> getFunctions() {
        return this.functions;
    }

    @Override
    public ConfigExtension getExtension() {
        return this.extension;
    }

    @Override
    public void setExtension(ConfigExtension extension) {
        this.extension = extension;
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(boolean metadataComplete) {
        this.metadataComplete = metadataComplete;
    }

    public Boolean getMetadataComplete() {
        return this.metadataComplete;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Taglib getTaglib() {
        return this.taglib;
    }

    public void setTaglib(Taglib taglib) {
        this.taglib = taglib;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    public boolean isEmpty() {
        return this.getComponents().isEmpty() && this.getBehaviors().isEmpty() && this.getConverters().isEmpty() && this.getEvents().isEmpty() && this.getFunctions().isEmpty() && this.getListeners().isEmpty() && this.getRenderKits().isEmpty() && this.getValidators().isEmpty() && (null == this.getExtension() || this.getExtension().getExtensions().isEmpty());
    }

    static <T extends ModelElement<T>> void merge(Collection<T> target, Collection<T> source) {
        for (ModelElement element : source) {
            Mergeable targetElement = null;
            if (null == targetElement) {
                target.add(element);
                continue;
            }
            targetElement.merge(element);
        }
    }

    static <T extends Mergeable<T>> void merge(T target, T source) {
        try {
            PropertyDescriptor[] properties;
            for (PropertyDescriptor propertyDescriptor : properties = Introspector.getBeanInfo(target.getClass()).getPropertyDescriptors()) {
                Method readMethod = propertyDescriptor.getReadMethod();
                Method writeMethod = propertyDescriptor.getWriteMethod();
                if (null == readMethod || null == writeMethod || !readMethod.isAnnotationPresent(Merge.class)) continue;
                boolean preferTrue = readMethod.getAnnotation(Merge.class).preferTrue();
                boolean overwrite = readMethod.getAnnotation(Merge.class).overwrite();
                Object oldValue = readMethod.invoke(target, new Object[0]);
                Object newValue = readMethod.invoke(source, new Object[0]);
                if (preferTrue) {
                    if (Boolean.TYPE == readMethod.getReturnType()) {
                        if (((Boolean)oldValue).booleanValue() || ((Boolean)newValue).booleanValue()) {
                            writeMethod.invoke(target, Boolean.TRUE);
                            continue;
                        }
                    } else {
                        throw new IllegalStateException("@Merge methods can be enforceTrue=true only for boolean properties: " + readMethod);
                    }
                }
                if (null == newValue || !overwrite && null != oldValue) continue;
                writeMethod.invoke(target, newValue);
            }
        }
        catch (IntrospectionException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void merge(ComponentLibrary library) {
        this.getComponents().addAll(library.getComponents());
        this.getRenderKits().addAll(library.getRenderKits());
        this.getConverters().addAll(library.getConverters());
        this.getValidators().addAll(library.getValidators());
        this.getBehaviors().addAll(library.getBehaviors());
        this.getFunctions().addAll(library.getFunctions());
        this.getEvents().addAll(library.getEvents());
        if (null != library.getMetadataComplete()) {
            this.setMetadataComplete(library.getMetadataComplete());
        }
        this.getExtension().getExtensions().addAll(library.getExtension().getExtensions());
        if (null != library.getTaglib()) {
            if (null == this.getTaglib()) {
                this.setTaglib(library.getTaglib());
            } else {
                JavaUtils.copyProperties(library.getTaglib(), this.getTaglib());
            }
        }
        if (null != library.getPrefix()) {
            this.setPrefix(library.getPrefix());
        }
    }

    @Override
    public void markUnchanged() {
        for (RenderKitModel renderKit : this.getRenderKits()) {
            for (RendererModel renderer : renderKit.getRenderers()) {
                renderer.markUnchanged();
            }
        }
        for (ComponentModel component : this.getComponents()) {
            component.markUnchanged();
        }
    }

    @Override
    public boolean hasChanged() {
        for (RenderKitModel renderKit : this.getRenderKits()) {
            for (RendererModel renderer : renderKit.getRenderers()) {
                if (!renderer.hasChanged()) continue;
                return true;
            }
        }
        for (ComponentModel component : this.getComponents()) {
            if (!component.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void stopTrackingChanges() {
        for (RenderKitModel renderKit : this.getRenderKits()) {
            for (RendererModel renderer : renderKit.getRenderers()) {
                renderer.stopTrackingChanges();
            }
        }
        for (ComponentModel component : this.getComponents()) {
            component.stopTrackingChanges();
        }
    }
}

