/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.model;

import java.io.Serializable;
import java.util.Comparator;
import org.richfaces.cdk.model.DescriptionGroupBase;
import org.richfaces.cdk.model.ModelCollection;
import org.richfaces.cdk.model.ModelSet;
import org.richfaces.cdk.model.Named;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.model.PropertyModel;

public class BeanModelBase
extends DescriptionGroupBase {
    private final ModelCollection<PropertyBase> attributes = ModelSet.create(new PropertyBaseComparator());

    public ModelCollection<PropertyBase> getAttributes() {
        return this.attributes;
    }

    public PropertyBase getAttribute(String name) {
        return this.attributes.find(new Named.NamePredicate(name));
    }

    public PropertyBase getOrCreateAttribute(String attributeName) {
        PropertyBase attribute = this.getAttribute(attributeName);
        if (null == attribute) {
            attribute = this.createAttribute();
            attribute.setName(attributeName);
            this.attributes.add(attribute);
        }
        return attribute;
    }

    protected PropertyBase createAttribute() {
        return new PropertyModel();
    }

    private static class PropertyBaseComparator
    implements Comparator<PropertyBase>,
    Serializable {
        private PropertyBaseComparator() {
        }

        @Override
        public int compare(PropertyBase o1, PropertyBase o2) {
            if (o1 != null && o2 != null && null != o1.getName() && null != o2.getName()) {
                return o1.getName().compareTo(o2.getName());
            }
            return 0;
        }
    }
}

