/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.generate.taglib;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.MessageFormat;
import javax.el.ValueExpression;
import org.richfaces.cdk.model.AttributeModel;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.EventModel;
import org.richfaces.cdk.model.PropertyBase;

public enum ListenerAttribute {
    FOR("for", false, ClassName.get(String.class)),
    BINDING("binding", false, ClassName.get(ValueExpression.class)),
    LISTENER("listener", false, ClassName.get(ValueExpression.class)),
    TYPE("type", false, ClassName.get(ValueExpression.class));

    private AttributeModel attribute;

    private ListenerAttribute(String name, boolean required, ClassName type) {
        this.attribute = new AttributeModel(name, required, type, "");
    }

    public PropertyBase derivateProperty(EventModel model) {
        String description = this.getDescription(model);
        return new AttributeModel(this.attribute.getName(), this.attribute.isRequired(), this.attribute.getType(), description);
    }

    private String getDescription(EventModel model) {
        try {
            Description annotation = ListenerAttribute.class.getField(this.toString()).getAnnotation(Description.class);
            Derivator derivator = annotation.derivator().newInstance();
            return derivator.derive(annotation.base(), model);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    @Inherited
    private static @interface Description {
        public String base();

        public Class<? extends Derivator> derivator();
    }

    static class EventNameDerivator
    extends Derivator {
        EventNameDerivator() {
        }

        @Override
        public Object[] derivateParameters(EventModel model) {
            return new Object[]{model.getType().getSimpleName()};
        }
    }

    static class ListenerNameDerivator
    extends Derivator {
        ListenerNameDerivator() {
        }

        @Override
        public Object[] derivateParameters(EventModel model) {
            return new Object[]{model.getListenerInterface().getSimpleName()};
        }
    }

    static class NoneDerivator
    extends Derivator {
        NoneDerivator() {
        }

        @Override
        public Object[] derivateParameters(EventModel model) {
            return new Object[0];
        }
    }

    public static abstract class Derivator {
        public String derive(String descriptionBase, EventModel model) {
            return MessageFormat.format(descriptionBase, this.derivateParameters(model));
        }

        public abstract Object[] derivateParameters(EventModel var1);
    }
}

