/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.generate.freemarker;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.CdkWriter;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.ModelElementBase;
import org.richfaces.cdk.model.Trackable;
import org.richfaces.cdk.model.ViewElement;

public abstract class FreeMarkerWriter<C>
implements CdkWriter {
    private final FreeMarkerRenderer configuration;
    private final FileManager output;

    public FreeMarkerWriter(FreeMarkerRenderer configuration, FileManager output) {
        this.configuration = configuration;
        this.output = output;
    }

    public void generate(ComponentLibrary library, C c) throws CdkException {
        try {
            Writer out = this.getOutput(library, c);
            if (null != out) {
                this.configuration.writeTemplate(this.getTemplateName(), c, out);
                out.close();
            }
        }
        catch (IOException e) {
            throw new CdkException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new CdkException((Throwable)e);
        }
    }

    protected Writer getOutput(ComponentLibrary library, C c) throws CdkException {
        long lastModified = Long.MIN_VALUE;
        if (c instanceof Trackable) {
            Trackable trackuble = (Trackable)c;
            lastModified = trackuble.lastModified();
        }
        try {
            return this.output.createOutput(this.getOutputFileName(c), lastModified);
        }
        catch (IOException e) {
            throw new CdkException((Throwable)e);
        }
    }

    protected String getOutputFileName(C c) throws CdkException {
        if (c instanceof ViewElement) {
            ModelElementBase modelElement = (ModelElementBase)c;
            return modelElement.getTargetClass().getName().replace('.', File.separatorChar) + ".java";
        }
        throw new CdkException("Unknown model object " + c);
    }

    protected String getJavaFileName(ClassName targetClass) {
        return targetClass.getName().replace('.', File.separatorChar) + ".java";
    }

    protected abstract String getTemplateName();
}

