/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.generate.freemarker;

import com.google.inject.Inject;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.generate.freemarker.ContextVariables;
import org.richfaces.cdk.generate.freemarker.DefaultImports;
import org.richfaces.cdk.generate.freemarker.FreeMakerUtils;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.generate.freemarker.TemplatesFolder;

public class CdkConfiguration
extends Configuration
implements FreeMarkerRenderer {
    private static final String TEMPLATES = "/META-INF/templates";
    private String templatesFolder = "/META-INF/templates";
    private Logger log;

    @Inject
    public CdkConfiguration(ObjectWrapper wrapper, Logger log, FreeMakerUtils utils) {
        this.log = log;
        this.setClassForTemplateLoading(this.getClass(), this.getTemplatesFolder());
        this.setTemplateUpdateDelay(10000);
        this.setSharedVariable("utils", (TemplateModel)utils);
        this.setObjectWrapper(wrapper);
    }

    @Inject(optional=true)
    public void setSharedVariables(@ContextVariables Map<String, Object> variables) {
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            try {
                this.setSharedVariable(entry.getKey(), entry.getValue());
            }
            catch (TemplateModelException e) {
                this.log.error((CharSequence)("Error to set shared variable " + entry.getKey()), (Throwable)e);
            }
        }
    }

    @Inject(optional=true)
    public synchronized void setImports(@DefaultImports Map<String, String> map) {
        super.setAutoImports(map);
    }

    @Override
    public void writeTemplate(String templateName, Object object, Writer writer) throws IOException, TemplateException {
        this.getTemplate(templateName).process(object, writer);
    }

    @Override
    public String renderTemplate(String templateName, Object object) {
        StringWriter writer = new StringWriter();
        try {
            this.writeTemplate(templateName, object, writer);
            return writer.toString();
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Error rendering template", (Throwable)e);
            return e.getMessage();
        }
        catch (TemplateException e) {
            this.log.error((CharSequence)"Error rendering template", (Throwable)e);
            return e.getMessage();
        }
    }

    @Inject(optional=true)
    public void setTemplatesFolder(@TemplatesFolder String templatesFolder) {
        this.setClassForTemplateLoading(this.getClass(), templatesFolder);
        this.templatesFolder = templatesFolder;
    }

    public String getTemplatesFolder() {
        return this.templatesFolder;
    }
}

