/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import java.lang.annotation.Annotation;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.richfaces.cdk.CdkProcessingException;
import org.richfaces.cdk.annotations.Event;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.apt.processors.ProcessorBase;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.EventModel;

public class EventProcessor
extends ProcessorBase
implements CdkAnnotationProcessor {
    @Override
    public Class<? extends Annotation> getProcessedAnnotation() {
        return Event.class;
    }

    @Override
    public void process(Element element, ComponentLibrary library) throws CdkProcessingException {
        if (ElementKind.CLASS.equals((Object)element.getKind())) {
            SourceUtils sourceUtils = this.getSourceUtils();
            TypeElement eventType = (TypeElement)element;
            AnnotationMirror event = sourceUtils.getAnnotationMirror(element, Event.class);
            EventModel model = new EventModel();
            model.setType(ClassName.parseName(eventType.getQualifiedName().toString()));
            sourceUtils.setModelProperty(model, event, "listenerInterface", "listener");
            sourceUtils.setModelProperty(model, event, "listenerMethod");
            sourceUtils.setModelProperty(model, event, "sourceInterface", "source");
            this.setTagInfo(event, model);
            library.getEvents().add(model);
        }
    }
}

