/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt;

import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.Output;
import org.richfaces.cdk.Outputs;
import org.richfaces.cdk.apt.CacheType;
import org.richfaces.cdk.apt.LibraryCache;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.util.SerializationUtils;

public class LibraryCacheImpl
implements LibraryCache {
    private CacheType cacheType;
    @Inject
    private Logger log;
    @Inject
    @Output(value=Outputs.LIBRARY_CACHE)
    private FileManager fileManager;
    @Inject(optional=true)
    @Named(value="libraryCachingEnabled")
    private boolean cachingEnabled = true;
    private ComponentLibrary cachedLibrary = null;

    public LibraryCacheImpl(CacheType cacheType) {
        this.cacheType = cacheType;
    }

    @Override
    public boolean available() {
        try {
            if (this.cachedLibrary != null) {
                return true;
            }
            if (this.cachingEnabled && this.getCacheFile().exists()) {
                this.load();
                return true;
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            this.cachingEnabled = false;
            this.log.info((CharSequence)("Unable to load library cache " + this.getFilename() + ". Full build will be ran and cache rewritten."), (Throwable)e);
        }
        return false;
    }

    public long lastModified() {
        try {
            return this.available() ? this.getCacheFile().lastModified() : 0L;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean storedBefore(long time) {
        return this.lastModified() < time;
    }

    @Override
    public ComponentLibrary load() {
        if (this.cachedLibrary != null) {
            return this.cachedLibrary;
        }
        try {
            byte[] bytes = Files.toByteArray((File)this.getCacheFile());
            this.cachedLibrary = (ComponentLibrary)SerializationUtils.deserializeFromBytes(bytes);
            return this.cachedLibrary;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void save(ComponentLibrary library) {
        try {
            byte[] bytes = SerializationUtils.serializeToBytes(library);
            try {
                this.fileManager.createOutput(this.getFilename(), System.currentTimeMillis());
                Files.write((byte[])bytes, (File)this.getCacheFile());
            }
            catch (IOException e) {
                this.log.warn((CharSequence)("Can't write to library cache file " + this.getFilename()), (Throwable)e);
            }
        }
        catch (Exception e) {
            this.log.warn((CharSequence)"can't serialize library model", (Throwable)e);
        }
    }

    private File getCacheFile() throws FileNotFoundException {
        String filename = this.getFilename();
        return this.fileManager.getFile(filename);
    }

    private String getFilename() {
        return (Object)((Object)this.cacheType) + ".ser";
    }
}

