/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.richfaces.cdk.Cache;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.apt.CacheType;
import org.richfaces.cdk.apt.DefaultLibraryCompiler;
import org.richfaces.cdk.apt.LibraryCache;
import org.richfaces.cdk.apt.LibraryCompilerWrapper;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.ComponentLibraryHolder;

public class IncrementalLibraryCompiler
extends LibraryCompilerWrapper {
    @Inject
    @Cache(value=CacheType.JAVA_SOURCES)
    public LibraryCache javaCache;
    @Inject
    @Cache(value=CacheType.NON_JAVA_SOURCES)
    public LibraryCache nonJavaCache;
    @Inject
    ComponentLibraryHolder holder;
    private ComponentLibrary javaSourcesLibrary = new ComponentLibrary();
    private ComponentLibrary nonJavaSourcesLibrary = new ComponentLibrary();

    @Inject
    public IncrementalLibraryCompiler(Injector injector) {
        super(new DefaultLibraryCompiler());
        injector.injectMembers((Object)this.delegate);
    }

    @Override
    public void beforeJavaSourceProcessing() {
        super.beforeJavaSourceProcessing();
        this.holder.setLibrary(new ComponentLibrary());
    }

    @Override
    public void afterJavaSourceProcessing() {
        super.afterJavaSourceProcessing();
        ComponentLibrary additionsToLibrary = this.holder.getLibrary();
        if (this.javaCache.available()) {
            ComponentLibrary cachedLibrary = this.javaCache.load();
            this.javaSourcesLibrary.merge(cachedLibrary);
            this.javaSourcesLibrary.markUnchanged();
        }
        this.javaSourcesLibrary.merge(additionsToLibrary);
        this.javaCache.save(this.javaSourcesLibrary);
        this.javaSourcesLibrary.stopTrackingChanges();
    }

    @Override
    public void processNonJavaSources() throws CdkException {
        if (this.nonJavaCache.available()) {
            ComponentLibrary cachedLibrary = this.nonJavaCache.load();
            this.nonJavaSourcesLibrary.merge(cachedLibrary);
            this.nonJavaSourcesLibrary.markUnchanged();
        }
        ComponentLibrary additionsToLibrary = new ComponentLibrary();
        this.holder.setLibrary(additionsToLibrary);
        super.processNonJavaSources();
        this.nonJavaSourcesLibrary.merge(additionsToLibrary);
        this.nonJavaCache.save(this.nonJavaSourcesLibrary);
        this.nonJavaSourcesLibrary.stopTrackingChanges();
    }

    @Override
    public void completeLibrary() throws CdkException {
        ComponentLibrary composedLibrary = new ComponentLibrary();
        composedLibrary.stopTrackingChanges();
        composedLibrary.merge(this.javaSourcesLibrary);
        composedLibrary.merge(this.nonJavaSourcesLibrary);
        this.holder.setLibrary(composedLibrary);
    }
}

