/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.ModelValidator;
import org.richfaces.cdk.TimeMeasure;
import org.richfaces.cdk.apt.CdkProcessor;
import org.richfaces.cdk.apt.LibraryCompiler;
import org.richfaces.cdk.apt.LibraryGenerator;
import org.richfaces.cdk.apt.SourceUtilsProvider;
import org.richfaces.cdk.model.ComponentLibrary;

public class CdkProcessorImpl
extends AbstractProcessor
implements CdkProcessor {
    private static final Set<String> PROCESSED_ANNOTATION = Collections.singleton("*");
    public static final String CACHE_EAGERLY_OPTION = "libraryCachingEagerly";
    @Inject
    private SourceUtilsProvider sourceUtilsProducer;
    @Inject
    private LibraryCompiler compiler;
    @Inject
    private LibraryGenerator generator;
    @Inject
    private ModelValidator validator;
    @Inject
    private ComponentLibrary library;
    @Inject(optional=true)
    @Named(value="libraryCachingEagerly")
    private boolean cachingEagerly = false;
    @Inject
    private Logger log;
    private boolean firstRound = true;
    private TimeMeasure time;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.sourceUtilsProducer.setProcessingEnv(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.time == null) {
            this.time = new TimeMeasure("java source processing", this.log).info(true);
        }
        if (!roundEnv.processingOver()) {
            if (this.firstRound) {
                this.firstRound = false;
                this.compiler.beforeJavaSourceProcessing();
                this.time.start();
            }
            this.compiler.processJavaSource(this.processingEnv, roundEnv);
        } else {
            this.time.stop();
            this.compiler.afterJavaSourceProcessing();
            this.continueAfterJavaSourceProcessing();
        }
        return false;
    }

    @Override
    public void continueAfterJavaSourceProcessing() {
        try {
            this.processNonJavaSources();
            this.completeLibrary();
        }
        catch (CdkException e) {
            this.sendError(e);
        }
        if (!this.library.hasChanged() && this.cachingEagerly) {
            this.log.info((CharSequence)"[caching eagerly - not continuing to verification and generation phase]");
            return;
        }
        try {
            this.verify();
        }
        catch (CdkException e) {
            this.sendError(e);
        }
        if (0 == this.log.getErrorCount()) {
            this.generate();
        }
    }

    private void processNonJavaSources() {
        this.time = new TimeMeasure("non-java source processing", this.log).info(true).start();
        this.compiler.processNonJavaSources();
        this.time.stop();
    }

    private void completeLibrary() {
        this.time = new TimeMeasure("library completion", this.log).info(true).start();
        this.compiler.completeLibrary();
        this.time.stop();
    }

    private void verify() {
        this.time = new TimeMeasure("library verification", this.log).info(true).start();
        this.validator.verify(this.library);
        this.time.stop();
    }

    private void generate() {
        this.time = new TimeMeasure("library generation", this.log).info(true).start();
        this.generator.generate();
        this.time.stop();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return PROCESSED_ANNOTATION;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_6;
    }

    private void sendError(CdkException e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
    }
}

