/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.SourceFileManager;

public class SourceFileManagerImpl
implements SourceFileManager,
FileManager {
    private final Iterable<File> sources;
    private final Iterable<File> folders;

    public SourceFileManagerImpl(Iterable<File> sources, Iterable<File> folders) {
        this.sources = sources;
        this.folders = folders;
    }

    @Override
    public Writer createOutput(String path, long lastModified) throws IOException {
        throw new UnsupportedOperationException("Cannot create file in source folder");
    }

    @Override
    public File getFile(String path) throws FileNotFoundException {
        String platformPath = File.separatorChar == '/' ? path : path.replace('/', File.separatorChar);
        if (null != this.folders) {
            for (File folder : this.folders) {
                File configFile;
                if (!folder.exists() || !folder.isDirectory() || !(configFile = new File(folder, platformPath)).exists()) continue;
                return configFile;
            }
        }
        if (null != this.sources) {
            for (File file : this.sources) {
                if (!file.getAbsolutePath().endsWith(platformPath)) continue;
                return file;
            }
        }
        throw new FileNotFoundException(path);
    }

    @Override
    public Iterable<File> getFiles() {
        return this.sources;
    }

    @Override
    public Iterable<File> getFolders() {
        return this.folders;
    }
}

