/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import org.richfaces.cdk.CDKHandler;
import org.richfaces.cdk.CacheImpl;
import org.richfaces.cdk.CdkClassLoader;
import org.richfaces.cdk.CdkModule;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.JavaLogger;
import org.richfaces.cdk.LibraryBuilder;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.ModelValidator;
import org.richfaces.cdk.NamingConventions;
import org.richfaces.cdk.OutputFileManagerImpl;
import org.richfaces.cdk.OutputImpl;
import org.richfaces.cdk.Outputs;
import org.richfaces.cdk.RichFacesConventions;
import org.richfaces.cdk.SourceFileManagerImpl;
import org.richfaces.cdk.SourceImpl;
import org.richfaces.cdk.Sources;
import org.richfaces.cdk.TimeMeasure;
import org.richfaces.cdk.apt.AptModule;
import org.richfaces.cdk.apt.CacheType;
import org.richfaces.cdk.apt.LibraryCache;
import org.richfaces.cdk.apt.LibraryCacheImpl;
import org.richfaces.cdk.generate.java.ClassGeneratorModule;
import org.richfaces.cdk.generate.taglib.TaglibModule;
import org.richfaces.cdk.model.ModelModule;
import org.richfaces.cdk.model.validator.ValidatorImpl;
import org.richfaces.cdk.templatecompiler.TemplateModule;
import org.richfaces.cdk.xmlconfig.XmlModule;

public class Generator {
    public static final String RENDERER_UTILS_CLASS = "rendererUtils";
    public static final String OPTIONS = "OPTIONS";
    private CdkClassLoader loader;
    private Logger log = new JavaLogger();
    private Injector injector;
    private String namespace;
    private Locale locale = Locale.getDefault();
    private Charset charset = Charset.defaultCharset();
    private Map<Outputs, FileManager> outputFolders = Maps.newEnumMap(Outputs.class);
    private Map<Sources, FileManager> sources = Maps.newEnumMap(Sources.class);
    private LibraryBuilder libraryBuilder;
    private Map<String, String> options = Maps.newHashMap();
    private java.util.logging.Logger logger;

    public Generator() {
        EmptyFileManager emptyFileManager = new EmptyFileManager();
        for (Sources sources : Sources.values()) {
            this.sources.put(sources, emptyFileManager);
        }
        for (Enum enum_ : Outputs.values()) {
            this.outputFolders.put((Outputs)enum_, emptyFileManager);
        }
    }

    public void setLoader(CdkClassLoader loader) {
        this.loader = loader;
    }

    public void setLog(Logger log) {
        this.log = log;
        try {
            freemarker.log.Logger.selectLoggerLibrary((int)1);
            freemarker.log.Logger.setCategoryPrefix((String)"org.richfaces.cdk.");
            this.logger = java.util.logging.Logger.getLogger("org.richfaces.cdk");
            this.logger.addHandler(new CDKHandler(log));
            if (log.isDebugEnabled()) {
                this.logger.setLevel(Level.ALL);
            } else if (log.isInfoEnabled()) {
                this.logger.setLevel(Level.INFO);
            } else if (log.isWarnEnabled()) {
                this.logger.setLevel(Level.WARNING);
            } else {
                this.logger.setLevel(Level.SEVERE);
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Throwable)e);
        }
    }

    public void addOutputFolder(Outputs type, File outputFolder) {
        this.outputFolders.put(type, new OutputFileManagerImpl(outputFolder));
    }

    public void addSources(Sources type, Iterable<File> files, Iterable<File> folders) {
        this.sources.put(type, new SourceFileManagerImpl(files, folders));
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public void init() {
        TimeMeasure time = new TimeMeasure("module instantiation", this.log).info(true).start();
        Module[] defaultModules = new Module[]{new CdkConfigurationModule(), new AptModule(), new ModelModule(), new ClassGeneratorModule(), new TemplateModule(), new XmlModule(), new TaglibModule()};
        ServiceLoader<CdkModule> overlayModules = ServiceLoader.load(CdkModule.class);
        Module modules = Modules.override((Module[])defaultModules).with(overlayModules);
        this.injector = Guice.createInjector((Stage)Stage.DEVELOPMENT, (Module[])new Module[]{modules});
        time.stop();
        if (!this.log.isDebugEnabled()) {
            try {
                freemarker.log.Logger.selectLoggerLibrary((int)0);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        this.libraryBuilder = (LibraryBuilder)this.injector.getInstance(LibraryBuilder.class);
    }

    public void execute() {
        Preconditions.checkNotNull((Object)this.libraryBuilder, (Object)"initialized");
        this.libraryBuilder.build();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public class CdkConfigurationModule
    extends AbstractModule {
        protected void configure() {
            this.bind(CdkClassLoader.class).toInstance((Object)Generator.this.loader);
            this.bind(Logger.class).toInstance((Object)Generator.this.log);
            this.bind(Locale.class).toInstance((Object)Generator.this.locale);
            this.bind(Charset.class).toInstance((Object)Generator.this.charset);
            this.bind(Generator.class).toInstance((Object)Generator.this);
            for (Map.Entry entry : Generator.this.outputFolders.entrySet()) {
                this.bind(FileManager.class).annotatedWith((Annotation)new OutputImpl((Outputs)((Object)entry.getKey()))).toInstance(entry.getValue());
            }
            for (Map.Entry entry : Generator.this.sources.entrySet()) {
                this.bind(FileManager.class).annotatedWith((Annotation)new SourceImpl((Sources)((Object)entry.getKey()))).toInstance(entry.getValue());
            }
            for (CacheType cacheType : CacheType.values()) {
                LibraryCacheImpl cache = new LibraryCacheImpl(cacheType);
                this.requestInjection(cache);
                this.bind(LibraryCache.class).annotatedWith((Annotation)new CacheImpl(cacheType)).toInstance((Object)cache);
            }
            this.bind(ModelValidator.class).to(ValidatorImpl.class);
            this.bind(NamingConventions.class).to(RichFacesConventions.class);
            Names.bindProperties((Binder)this.binder(), (Map)Generator.this.options);
        }
    }

    public static final class EmptyFileManager
    implements FileManager {
        @Override
        public Iterable<File> getFolders() {
            return Collections.emptyList();
        }

        @Override
        public Iterable<File> getFiles() {
            return Collections.emptyList();
        }

        @Override
        public File getFile(String path) throws FileNotFoundException {
            throw new FileNotFoundException();
        }

        @Override
        public Writer createOutput(String path, long lastModified) throws IOException {
            throw new IOException("read-only");
        }
    }
}

