/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xml.internal;

import java.io.IOException;
import java.util.logging.Level;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.data.Reference;

public class ContextResolver
implements URIResolver {
    private final Context context;

    public ContextResolver(Context context) {
        this.context = context;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        StreamSource result = null;
        if (this.context != null) {
            Reference targetRef = null;
            if (base != null && !base.equals("")) {
                Reference baseRef = new Reference(base);
                targetRef = new Reference(baseRef, href);
            } else {
                targetRef = new Reference(href);
            }
            String targetUri = targetRef.getTargetRef().toString();
            Response response = this.context.getClientDispatcher().handle(new Request(Method.GET, targetUri));
            if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
                try {
                    result = new StreamSource(response.getEntity().getStream());
                    result.setSystemId(targetUri);
                }
                catch (IOException e) {
                    this.context.getLogger().log(Level.WARNING, "I/O error while getting the response stream", e);
                }
            }
        }
        return result;
    }
}

