/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.DocumentedInfo;
import org.restlet.ext.wadl.LinkInfo;
import org.restlet.ext.wadl.OptionInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.ext.xml.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ParameterInfo
extends DocumentedInfo {
    private String defaultValue;
    private String fixed;
    private String identifier;
    private LinkInfo link;
    private String name;
    private List<OptionInfo> options;
    private String path;
    private boolean repeating;
    private boolean required;
    private ParameterStyle style;
    private String type;

    public ParameterInfo() {
    }

    public ParameterInfo(String name, boolean required, String type, ParameterStyle style, String documentation) {
        super(documentation);
        this.name = name;
        this.required = required;
        this.style = style;
        this.type = type;
    }

    public ParameterInfo(String name, ParameterStyle style, DocumentationInfo documentation) {
        super(documentation);
        this.name = name;
        this.style = style;
    }

    public ParameterInfo(String name, ParameterStyle style, List<DocumentationInfo> documentations) {
        super(documentations);
        this.name = name;
        this.style = style;
    }

    public ParameterInfo(String name, ParameterStyle style, String documentation) {
        super(documentation);
        this.name = name;
        this.style = style;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getFixed() {
        return this.fixed;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public LinkInfo getLink() {
        return this.link;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OptionInfo> getOptions() {
        List<OptionInfo> o = this.options;
        if (o == null) {
            ParameterInfo parameterInfo = this;
            synchronized (parameterInfo) {
                o = this.options;
                if (o == null) {
                    this.options = o = new ArrayList<OptionInfo>();
                }
            }
        }
        return o;
    }

    public String getPath() {
        return this.path;
    }

    public ParameterStyle getStyle() {
        return this.style;
    }

    public String getType() {
        return this.type;
    }

    public boolean isRepeating() {
        return this.repeating;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setFixed(String fixed) {
        this.fixed = fixed;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setLink(LinkInfo link) {
        this.link = link;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(List<OptionInfo> options) {
        this.options = options;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRepeating(boolean repeating) {
        this.repeating = repeating;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setStyle(ParameterStyle style) {
        this.style = style;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void updateNamespaces(Map<String, String> namespaces) {
        namespaces.putAll(this.resolveNamespaces());
        if (this.getLink() != null) {
            this.getLink().updateNamespaces(namespaces);
        }
        for (OptionInfo optionInfo : this.getOptions()) {
            optionInfo.updateNamespaces(namespaces);
        }
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getDefaultValue() != null && !this.getDefaultValue().equals("")) {
            attributes.addAttribute("", "default", null, "xs:string", this.getDefaultValue());
        }
        if (this.getFixed() != null && !this.getFixed().equals("")) {
            attributes.addAttribute("", "fixed", null, "xs:string", this.getFixed());
        }
        if (this.getIdentifier() != null && !this.getIdentifier().equals("")) {
            attributes.addAttribute("", "id", null, "xs:ID", this.getIdentifier());
        }
        if (this.getPath() != null && !this.getPath().equals("")) {
            attributes.addAttribute("", "path", null, "xs:string", this.getPath());
        }
        if (this.getStyle() != null) {
            attributes.addAttribute("", "style", null, "xs:string", this.getStyle().toString());
        }
        if (this.getName() != null && !this.getName().equals("")) {
            attributes.addAttribute("", "name", null, "xs:NMTOKEN", this.getName());
        }
        if (this.getType() != null && !this.getType().equals("")) {
            attributes.addAttribute("", "type", null, "xs:QName", this.getType());
        }
        if (this.isRepeating()) {
            attributes.addAttribute("", "repeating", null, "xs:boolean", "true");
        }
        if (this.isRequired()) {
            attributes.addAttribute("", "required", null, "xs:boolean", "true");
        }
        if (this.getLink() == null && this.getDocumentations().isEmpty() && this.getOptions().isEmpty()) {
            writer.emptyElement("http://wadl.dev.java.net/2009/02", "param", null, (Attributes)attributes);
        } else {
            writer.startElement("http://wadl.dev.java.net/2009/02", "param", null, (Attributes)attributes);
            if (this.getLink() != null) {
                this.getLink().writeElement(writer);
            }
            for (DocumentationInfo documentationInfo : this.getDocumentations()) {
                documentationInfo.writeElement(writer);
            }
            for (OptionInfo optionInfo : this.getOptions()) {
                optionInfo.writeElement(writer);
            }
            writer.endElement("http://wadl.dev.java.net/2009/02", "param");
        }
    }
}

