/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;

public class ComponentRegistry {
    private final Log log = LogFactory.getLog(ComponentRegistry.class);
    protected Map<ComponentName, RegistrationInfoImpl> components = new HashMap<ComponentName, RegistrationInfoImpl>();
    protected Map<ComponentName, ComponentName> aliases = new HashMap<ComponentName, ComponentName>();
    protected MappedSet requirements = new MappedSet();
    protected MappedSet pendings = new MappedSet();

    public void destroy() {
        this.components = null;
        this.aliases = null;
        this.requirements = null;
        this.pendings = null;
    }

    protected ComponentName unaliased(ComponentName name) {
        ComponentName alias = this.aliases.get(name);
        return alias == null ? name : alias;
    }

    public final boolean isResolved(ComponentName name) {
        RegistrationInfo ri = this.components.get(this.unaliased(name));
        if (ri == null) {
            return false;
        }
        return ri.getState() > 1;
    }

    protected final boolean computePendings(RegistrationInfo ri) {
        Set<ComponentName> set = ri.getRequiredComponents();
        if (set == null || set.isEmpty()) {
            return false;
        }
        boolean hasUnresolvedDependencies = false;
        for (ComponentName name : set) {
            if (!this.isResolved(name)) {
                this.pendings.put(ri.getName(), name);
                hasUnresolvedDependencies = true;
            }
            this.requirements.put(name, ri.getName());
        }
        return hasUnresolvedDependencies;
    }

    public boolean addComponent(RegistrationInfoImpl ri) {
        ComponentName name = ri.getName();
        Set<ComponentName> al = ri.getAliases();
        String aliasInfo = al.isEmpty() ? "" : ", aliases=" + al;
        this.log.info((Object)("Registering component: " + name + aliasInfo));
        ri.register();
        this.components.put(name, ri);
        for (ComponentName n : al) {
            this.aliases.put(n, name);
        }
        boolean hasUnresolvedDependencies = this.computePendings(ri);
        if (!hasUnresolvedDependencies) {
            this.resolveComponent(ri);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistrationInfoImpl removeComponent(ComponentName name) {
        RegistrationInfoImpl ri = this.components.remove(name);
        if (ri != null) {
            try {
                this.unresolveComponent(ri);
            }
            finally {
                ri.unregister();
            }
        }
        return ri;
    }

    public Set<ComponentName> getMissingDependencies(ComponentName name) {
        return this.pendings.get(name);
    }

    public RegistrationInfoImpl getComponent(ComponentName name) {
        return this.components.get(this.unaliased(name));
    }

    public boolean contains(ComponentName name) {
        return this.components.containsKey(this.unaliased(name));
    }

    public int size() {
        return this.components.size();
    }

    public Collection<RegistrationInfoImpl> getComponents() {
        return this.components.values();
    }

    public RegistrationInfoImpl[] getComponentsArray() {
        return this.components.values().toArray(new RegistrationInfoImpl[this.components.size()]);
    }

    public Map<ComponentName, Set<ComponentName>> getPendingComponents() {
        return this.pendings.map;
    }

    protected void resolveComponent(RegistrationInfoImpl ri) {
        ComponentName riName = ri.getName();
        HashSet<ComponentName> names = new HashSet<ComponentName>();
        names.add(riName);
        names.addAll(ri.getAliases());
        ri.resolve();
        HashSet<ComponentName> dependsOnMe = new HashSet<ComponentName>();
        for (ComponentName n : names) {
            Set<ComponentName> reqs = this.requirements.get(n);
            if (reqs == null) continue;
            dependsOnMe.addAll(reqs);
        }
        if (dependsOnMe == null || dependsOnMe.isEmpty()) {
            return;
        }
        for (ComponentName name : dependsOnMe) {
            for (ComponentName n : names) {
                this.pendings.remove(name, n);
            }
            Set<ComponentName> set = this.pendings.get(name);
            if (set != null && !set.isEmpty()) continue;
            RegistrationInfoImpl waitingRi = this.components.get(name);
            this.resolveComponent(waitingRi);
        }
    }

    protected void unresolveComponent(RegistrationInfoImpl ri) {
        Set<ComponentName> set;
        Set<ComponentName> reqs = ri.getRequiredComponents();
        ComponentName name = ri.getName();
        ri.unresolve();
        this.pendings.remove(name);
        if (reqs != null) {
            for (ComponentName req : reqs) {
                this.requirements.remove(req, name);
            }
        }
        if ((set = this.requirements.get(name)) != null && !set.isEmpty()) {
            for (ComponentName dep : set.toArray(new ComponentName[set.size()])) {
                RegistrationInfoImpl depRi = this.components.get(dep);
                if (depRi == null) continue;
                this.unresolveComponent(depRi);
            }
        }
    }

    static class MappedSet {
        protected Map<ComponentName, Set<ComponentName>> map = new HashMap<ComponentName, Set<ComponentName>>();

        public Set<ComponentName> get(ComponentName name) {
            return this.map.get(name);
        }

        public Set<ComponentName> put(ComponentName key, ComponentName value) {
            Set<ComponentName> set = this.map.get(key);
            if (set == null) {
                set = new HashSet<ComponentName>();
                this.map.put(key, set);
            }
            set.add(value);
            return set;
        }

        public Set<ComponentName> remove(ComponentName key) {
            return this.map.remove(key);
        }

        public Set<ComponentName> remove(ComponentName key, ComponentName value) {
            Set<ComponentName> set = this.map.get(key);
            if (set != null) {
                set.remove(value);
                if (set.isEmpty()) {
                    this.map.remove(key);
                }
            }
            return set;
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public int size() {
            return this.map.size();
        }

        public void clear() {
            this.map.clear();
        }
    }
}

