/*
 * (C) Copyright 2006-2007 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id$
 */

package org.nuxeo.runtime.remoting.net.impl;

import java.io.Serializable;

import org.nuxeo.runtime.remoting.net.NodeInfo;

/**
 * @author  <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 *
 */
public interface NetworkPeer {

    /**
     * I detected you and want to connect.
     *
     * @param uri the server that wants to connect to me
     */
    void syn(NodeInfo info) throws Exception;

    /**
     * The node identified by uri wants to close the connection.
     *
     * @param uri
     */
    void close(String uri);

    void handleEvent(String source, Serializable message) throws Exception;

    NodeInfo[] getPeers();

    NodeInfo getNodeInfo();

}
