/*
 * (C) Copyright 2006-2007 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id$
 */

package org.nuxeo.runtime.remoting.net;

import java.io.Serializable;

/**
 * @author  <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 *
 */
public class NodeInfo implements Serializable {

    private static final long serialVersionUID = 116405393947110529L;

    public final String uri;
    public String name;
    public String description;

    public NodeInfo(String uri) {
        this(uri, null, null);
    }

    public NodeInfo(String uri, String name) {
        this(uri, name, null);
    }

    public NodeInfo(String uri, String name, String description) {
        this.uri = uri;
        this.name = name;
        this.description = description;
    }

    @Override
    public String toString() {
        return (name == null ? "Node" : name) +  " <" + uri + '>';
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NodeInfo) {
            NodeInfo info = (NodeInfo) obj;
            if (!uri.equals(info.uri)) {
                return false;
            }
            if (name != null && !name.equals(info.name)) {
                return false;
            }
            if (description != null && !description.equals(info.description)) {
                return false;
            }
            return  true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = uri.hashCode();
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        return result;
    }

}
