/*
 * (C) Copyright 2007 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id$
 */

package org.nuxeo.runtime.api;

import java.util.Properties;

import javax.naming.InitialContext;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 *
 */
public class JBossServiceLocator extends JndiServiceLocator {

    private String prefix;

    private String suffix;

    @Override
    public void initialize(String host, int port, Properties properties)
            throws Exception {
        if (properties != null) {
            prefix = properties.getProperty("prefix", "nuxeo/");
            suffix = properties.getProperty("suffix", "/remote");
        } else {
            properties = new Properties();
            properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            properties.put("java.naming.provider.url", "jnp://localhost:1099");
            properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");                        
        }
        if (host != null) { // overwrite default values (or those specified through properties)
            String uri = "jnp://" + host + ":" + (port == 0 ? 1099 : port);
            properties.put("java.naming.provider.url", uri);
        }        
        context = new InitialContext(properties);
    }
    
    @Override
    public Object lookup(ServiceDescriptor sd) throws Exception {
        String locator = sd.getLocator();
        if (locator == null) {
            locator = prefix + sd.getServiceClassSimpleName() + suffix;
            sd.setLocator(locator);
        } else if (locator.startsWith("%")) {
            locator = prefix + locator.substring(1) + suffix;
            sd.setLocator(locator);
        }
        return lookup(locator);
    }

}
