/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi.util.jar.index;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.nuxeo.runtime.osgi.util.jar.index.JarFileKind;

class JarMetaIndex {
    protected File file;
    private volatile HashSet<String> indexSet;
    private JarFileKind jarFileKind;

    public JarMetaIndex(String fileName) throws IOException {
        this.file = new File(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashSet<String> getMetaIndex() throws IOException {
        if (this.indexSet == null) {
            JarMetaIndex jarMetaIndex = this;
            synchronized (jarMetaIndex) {
                if (this.indexSet != null) {
                    return this.indexSet;
                }
                this.indexSet = new HashSet();
                try (JarFile jar = new JarFile(this.file);){
                    Enumeration<JarEntry> entries = jar.entries();
                    boolean containsOnlyClass = true;
                    boolean containsOnlyResource = true;
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (entry.isDirectory() || name.equals("META-INF/MANIFEST.MF")) continue;
                        if (containsOnlyResource || containsOnlyClass) {
                            if (name.endsWith(".class")) {
                                containsOnlyResource = false;
                            } else {
                                containsOnlyClass = false;
                            }
                        }
                        if (name.startsWith("META-INF")) {
                            this.indexSet.add(name);
                            continue;
                        }
                        String[] pkgElements = name.split("/");
                        if (pkgElements.length <= 2) continue;
                        String meta = null;
                        if (pkgElements.length > 3 && pkgElements[0].equals("com") && pkgElements[1].equals("sun")) {
                            if (pkgElements.length > 4 && pkgElements[2].equals("java")) {
                                int bound = 0;
                                bound = pkgElements[3].equals("util") ? pkgElements.length - 1 : 4;
                                meta = "";
                                for (int j = 0; j < bound; ++j) {
                                    meta = meta + pkgElements[j] + "/";
                                }
                            } else {
                                meta = pkgElements[0] + "/" + pkgElements[1] + "/" + pkgElements[2] + "/";
                            }
                        } else {
                            meta = pkgElements[0] + "/" + pkgElements[1] + "/";
                        }
                        this.indexSet.add(meta);
                    }
                    this.jarFileKind = containsOnlyClass ? JarFileKind.CLASSONLY : (containsOnlyResource ? JarFileKind.RESOURCEONLY : JarFileKind.MIXED);
                }
            }
        }
        return this.indexSet;
    }

    JarFileKind getJarFileKind() throws IOException {
        if (this.indexSet == null) {
            this.indexSet = this.getMetaIndex();
        }
        return this.jarFileKind;
    }
}

