/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi.util.jar.index;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.nuxeo.runtime.osgi.util.jar.index.JarMetaIndex;

public class BuildMetaIndex {
    public static void main(String ... args) throws IOException {
        if (args.length < 3 || !args[0].equals("-o")) {
            BuildMetaIndex.printUsage();
            System.exit(1);
        }
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(args[1]));
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("FileNotFoundException occurred");
            System.exit(2);
        }
        try {
            BuildMetaIndex.build(out, Arrays.copyOfRange(args, 2, args.length));
        }
        finally {
            out.close();
        }
    }

    public static void build(PrintStream out, String ... args) throws IOException {
        out.println("% VERSION 2");
        out.println("% WARNING: this file is auto-generated; do not edit");
        out.println("% UNSUPPORTED: this file and its format may change and/or");
        out.println("%   may be removed in a future release");
        for (int i = 0; i < args.length; ++i) {
            String filename = args[i];
            JarMetaIndex jmi = new JarMetaIndex(filename);
            HashSet<String> index = jmi.getMetaIndex();
            if (index == null) continue;
            out.println(jmi.getJarFileKind().getMarkerChar() + " " + filename);
            Iterator<String> iter = index.iterator();
            while (iter.hasNext()) {
                out.println(iter.next());
            }
        }
        out.flush();
    }

    private static void printUsage() {
        String usage = "BuildMetaIndex is used to generate a meta index file for the jar files\nyou specified. The following is its usage:\n java BuildMetaIndex -o <the output meta index file> <a list of jar files> \n You can specify *.jar to refer to all the jar files in the current directory";
        System.err.println(usage);
    }
}

