/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.nuxeo.osgi.application.SharedClassLoader;

public class DelegateLoader
implements SharedClassLoader {
    protected final URLClassLoader loader;
    protected Method addUrl;

    public DelegateLoader(URLClassLoader loader) {
        this.loader = loader;
        try {
            this.addUrl = loader.getClass().getDeclaredMethod("addURL", URL.class);
            this.addUrl.setAccessible(true);
        }
        catch (Exception e) {
            throw new Error("Failed to create a shared delegate loader for classloader: " + loader, e);
        }
    }

    @Override
    public void addURL(URL url) {
        try {
            this.addUrl.invoke((Object)this.loader, url);
        }
        catch (Throwable e) {
            throw new Error("Failed to add an URL to this loader: " + url, e);
        }
    }

    @Override
    public URL[] getURLs() {
        return this.loader.getURLs();
    }

    @Override
    public ClassLoader getLoader() {
        return this.loader;
    }
}

