/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jetty;

import java.util.HashMap;
import java.util.Map;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.nuxeo.runtime.jetty.FilterDescriptor;
import org.nuxeo.runtime.jetty.ServletDescriptor;

public class ContextManager {
    protected Server server;
    protected Map<String, Context> contexts;

    public ContextManager(Server server) {
        this.server = server;
        this.contexts = new HashMap<String, Context>();
    }

    public Server getServer() {
        return this.server;
    }

    public synchronized void addFilter(FilterDescriptor descriptor) {
        Map<String, String> params;
        String desc;
        String path = descriptor.getContext();
        Context ctx = this.contexts.get(path);
        if (ctx == null) {
            ctx = new Context((HandlerContainer)this.server, path, 1);
            this.contexts.put(path, ctx);
        }
        FilterHolder holder = new FilterHolder(descriptor.getClazz());
        String name = descriptor.getName();
        if (name != null) {
            holder.setName(name);
        }
        if ((desc = descriptor.getDescription()) != null) {
            holder.setDisplayName(desc);
        }
        if ((params = descriptor.getInitParams()) != null) {
            holder.setInitParameters(params);
        }
        ctx.addFilter(holder, descriptor.getPath(), 0);
    }

    public synchronized void addServlet(ServletDescriptor descriptor) {
        Map<String, String> params;
        String desc;
        String path = descriptor.getContext();
        Context ctx = this.contexts.get(path);
        if (ctx == null) {
            ctx = new Context((HandlerContainer)this.server, path, 1);
            this.contexts.put(path, ctx);
        }
        ServletHolder holder = new ServletHolder(descriptor.getClazz());
        String name = descriptor.getName();
        if (name != null) {
            holder.setName(name);
        }
        if ((desc = descriptor.getDescription()) != null) {
            holder.setDisplayName(desc);
        }
        if ((params = descriptor.getInitParams()) != null) {
            holder.setInitParameters(params);
        }
        ctx.addServlet(holder, descriptor.getPath());
    }

    public synchronized void removeFilter(FilterDescriptor descriptor) {
    }

    public synchronized void removeServlet(ServletDescriptor descriptor) {
    }
}

