/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.daemon;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private static final AtomicInteger count = new AtomicInteger(0);
    private String basename;
    private boolean isDaemon;

    public DaemonThreadFactory(String basename) {
        this(basename, true);
    }

    public DaemonThreadFactory(String basename, boolean isDaemon) {
        this.basename = basename;
        this.isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, this.basename + "-" + count.getAndIncrement());
        thread.setDaemon(this.isDaemon);
        return thread;
    }
}

