/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.LoggerRepository;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.gui.ColoredTextPane;
import org.nuxeo.launcher.gui.NuxeoLauncherGUI;
import org.nuxeo.log4j.Log4JHelper;
import org.nuxeo.shell.Shell;
import org.nuxeo.shell.cmds.ConsoleReaderFactory;
import org.nuxeo.shell.cmds.Interactive;
import org.nuxeo.shell.cmds.InteractiveShellHandler;
import org.nuxeo.shell.swing.ConsolePanel;

public class NuxeoFrame
extends JFrame {
    protected static final Log log = LogFactory.getLog(NuxeoFrame.class);
    private static final long serialVersionUID = 1L;
    protected final ImageIcon startIcon = this.getImageIcon("icons/start.png");
    protected final ImageIcon stopIcon = this.getImageIcon("icons/stop.png");
    protected final ImageIcon appIcon = this.getImageIcon("icons/control_panel_icon_32.png");
    protected JButton mainButton = null;
    protected NuxeoLauncherGUI controller;
    protected boolean logsShown = false;
    protected JButton logsButton;
    private GridBagConstraints constraints;
    protected NuxeoFrame contentPane;
    protected Component filler;
    private JTabbedPane tabbedPanel;
    protected ConsolePanel consolePanel;
    private JLabel summaryStatus;
    private JLabel summaryURL;

    public NuxeoFrame(NuxeoLauncherGUI controller) throws HeadlessException {
        super("NuxeoCtl");
        this.controller = controller;
        this.setDefaultCloseOperation(3);
        this.setIconImage(this.appIcon.getImage());
        this.getContentPane().setBackground(new Color(55, 55, 55));
        this.getContentPane().setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.gridx = 0;
        this.constraints.anchor = 19;
        JComponent header = this.buildHeader();
        header.setPreferredSize(new Dimension(480, 110));
        this.getContentPane().add((Component)header, this.constraints);
        this.constraints.fill = 1;
        this.constraints.ipady = 100;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.getContentPane().add((Component)this.buildTabbedPanel(), this.constraints);
        this.constraints.fill = 0;
        this.constraints.anchor = 20;
        this.constraints.ipady = 0;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.buildFooter(), this.constraints);
    }

    private Component buildConsolePanel() {
        try {
            this.consolePanel = new ConsolePanel();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        Interactive.setConsoleReaderFactory((ConsoleReaderFactory)this.consolePanel.getConsole());
        Interactive.setHandler((InteractiveShellHandler)new InteractiveShellHandler(){

            public void enterInteractiveMode() {
                Interactive.reset();
            }

            public boolean exitInteractiveMode(int code) {
                if (code == 1) {
                    Interactive.reset();
                    Shell.reset();
                    return true;
                }
                NuxeoFrame.this.consolePanel.getConsole().reset();
                return false;
            }
        });
        new Thread(){

            @Override
            public void run() {
                try {
                    Shell.get().main(new String[]{NuxeoFrame.this.controller.launcher.getURL() + "site/automation"});
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }.start();
        return this.consolePanel;
    }

    private JComponent buildFooter() {
        JLabel label = new JLabel(NuxeoLauncherGUI.getMessage("footer.label"));
        label.setForeground(Color.WHITE);
        label.setPreferredSize(new Dimension(470, 16));
        label.setFont(new Font(label.getFont().getName(), label.getFont().getStyle(), 9));
        label.setHorizontalAlignment(0);
        return label;
    }

    private JComponent buildHeader() {
        ImagePanel headerLogo = new ImagePanel(this.getImageIcon("img/nuxeo_control_panel_logo.png"), this.getImageIcon("img/nuxeo_control_panel_bg.png"));
        headerLogo.setLayout(new GridBagLayout());
        GridBagConstraints headerConstraints = new GridBagConstraints();
        headerConstraints.gridx = 0;
        headerLogo.add((Component)this.buildMainButton(), headerConstraints);
        return headerLogo;
    }

    private JComponent buildLogsTab() {
        JTabbedPane logsTabbedPane = new JTabbedPane(1);
        ArrayList logFiles = Log4JHelper.getFileAppendersFiles((LoggerRepository)LogManager.getLoggerRepository());
        logFiles.addAll(this.controller.getConfigurationGenerator().getLogFiles());
        for (String logFile : logFiles) {
            logsTabbedPane.addTab(new File(logFile).getName(), this.buildLogPanel(logFile));
        }
        return logsTabbedPane;
    }

    private JComponent buildLogPanel(String logFile) {
        ColoredTextPane textArea = new ColoredTextPane();
        textArea.setEditable(false);
        textArea.setAutoscrolls(true);
        textArea.setBackground(new Color(64, 64, 64));
        JScrollPane logsScroller = new JScrollPane(textArea);
        logsScroller.setVisible(true);
        logsScroller.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        logsScroller.setAutoscrolls(true);
        logsScroller.setVerticalScrollBarPolicy(22);
        logsScroller.setWheelScrollingEnabled(true);
        logsScroller.setPreferredSize(new Dimension(450, 160));
        this.controller.initLogsManagement(logFile, textArea);
        logsScroller.addComponentListener(new LogsPanelListener(logFile));
        return logsScroller;
    }

    private JComponent buildMainButton() {
        this.mainButton = this.createButton(new StartStopAction(), null);
        this.updateMainButton();
        return this.mainButton;
    }

    private Component buildSummaryPanel() {
        JPanel summaryPanel = new JPanel();
        summaryPanel.setLayout(new BoxLayout(summaryPanel, 3));
        summaryPanel.setBackground(new Color(55, 55, 55));
        summaryPanel.setForeground(Color.WHITE);
        summaryPanel.add(new JLabel("<html><font color=#ffffdd>" + NuxeoLauncherGUI.getMessage("summary.status.label")));
        this.summaryStatus = new JLabel(this.controller.launcher.status());
        this.summaryStatus.setForeground(Color.WHITE);
        summaryPanel.add(this.summaryStatus);
        summaryPanel.add(new JLabel("<html><font color=#ffffdd>" + NuxeoLauncherGUI.getMessage("summary.url.label")));
        this.summaryURL = new JLabel(this.controller.launcher.getURL());
        this.summaryURL.setForeground(Color.WHITE);
        summaryPanel.add(this.summaryURL);
        summaryPanel.add(new JSeparator());
        ConfigurationGenerator config = this.controller.launcher.getConfigurationGenerator();
        summaryPanel.add(new JLabel("<html><font color=#ffffdd>" + NuxeoLauncherGUI.getMessage("summary.homedir.label")));
        summaryPanel.add(new JLabel("<html><font color=white>" + config.getNuxeoHome().getPath()));
        summaryPanel.add(new JLabel("<html><font color=#ffffdd>" + NuxeoLauncherGUI.getMessage("summary.nuxeoconf.label")));
        summaryPanel.add(new JLabel("<html><font color=white>" + config.getNuxeoConf().getPath()));
        summaryPanel.add(new JLabel("<html><font color=#ffffdd>" + NuxeoLauncherGUI.getMessage("summary.datadir.label")));
        summaryPanel.add(new JLabel("<html><font color=white>" + config.getDataDir().getPath()));
        return summaryPanel;
    }

    private JComponent buildTabbedPanel() {
        this.tabbedPanel = new JTabbedPane(1);
        this.tabbedPanel.addTab(NuxeoLauncherGUI.getMessage("tab.summary.title"), this.buildSummaryPanel());
        this.tabbedPanel.addTab(NuxeoLauncherGUI.getMessage("tab.logs.title"), this.buildLogsTab());
        this.tabbedPanel.addTab(NuxeoLauncherGUI.getMessage("tab.shell.title"), this.buildConsolePanel());
        this.tabbedPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane pane = (JTabbedPane)e.getSource();
                if (pane.getSelectedIndex() == 2) {
                    NuxeoFrame.this.consolePanel.getConsole().requestFocusInWindow();
                }
            }
        });
        return this.tabbedPanel;
    }

    private JButton createButton(ActionListener action, ImageIcon icon) {
        JButton button = new JButton();
        button.addActionListener(action);
        button.setIcon(icon);
        return button;
    }

    public void debug(JComponent parent) {
        for (Component comp : parent.getComponents()) {
            if (!(comp instanceof JComponent)) continue;
            ((JComponent)comp).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), ((JComponent)comp).getBorder()));
            log.info((Object)(comp.getClass() + " size: " + ((JComponent)comp).getSize()));
        }
    }

    protected ImageIcon getImageIcon(String resourcePath) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getClassLoader().getResource(resourcePath));
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return new ImageIcon(image);
    }

    protected void updateMainButton() {
        if (this.controller.launcher.isRunning()) {
            this.mainButton.setText(NuxeoLauncherGUI.getMessage("mainbutton.stop.text"));
            this.mainButton.setToolTipText(NuxeoLauncherGUI.getMessage("mainbutton.stop.tooltip"));
            this.mainButton.setIcon(this.stopIcon);
        } else {
            this.mainButton.setText(NuxeoLauncherGUI.getMessage("mainbutton.start.text"));
            this.mainButton.setToolTipText(NuxeoLauncherGUI.getMessage("mainbutton.start.tooltip"));
            this.mainButton.setIcon(this.startIcon);
        }
        this.mainButton.setEnabled(true);
        this.mainButton.validate();
    }

    public void updateSummary() {
        this.summaryStatus.setText(this.controller.launcher.status());
        this.summaryURL.setText(this.controller.launcher.getURL());
    }

    protected class StartStopAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected StartStopAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NuxeoFrame.this.mainButton.setEnabled(false);
            if (NuxeoFrame.this.controller.launcher.isRunning()) {
                NuxeoFrame.this.controller.stop();
            } else {
                NuxeoFrame.this.controller.start();
            }
        }
    }

    protected final class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Image backgroundImage;

        ImagePanel(Icon image, ImageIcon backgroundImage) {
            this.backgroundImage = backgroundImage.getImage();
            this.setOpaque(false);
            this.add(new JLabel(image));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.backgroundImage, 0, 0, this);
        }
    }

    private class LogsPanelListener
    extends ComponentAdapter {
        private String logFile;

        public LogsPanelListener(String logFile) {
            this.logFile = logFile;
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            NuxeoFrame.this.controller.notifyLogsObserver(this.logFile, false);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            NuxeoFrame.this.controller.notifyLogsObserver(this.logFile, true);
        }
    }
}

