/*
 * jQuery UI Autocomplete 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/autocomplete/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 *	jquery.ui.position.js
 *	jquery.ui.menu.js
 */
(function(A,B){var C=0;
A.widget("ui.autocomplete",{version:"1.10.3",defaultElement:"<input>",options:{appendTo:null,autoFocus:false,delay:300,minLength:1,position:{my:"left top",at:"left bottom",collision:"none"},source:null,change:null,close:null,focus:null,open:null,response:null,search:null,select:null},pending:0,_create:function(){var F,D,G,I=this.element[0].nodeName.toLowerCase(),H=I==="textarea",E=I==="input";
this.isMultiLine=H?true:E?false:this.element.prop("isContentEditable");
this.valueMethod=this.element[H||E?"val":"text"];
this.isNewMenu=true;
this.element.addClass("ui-autocomplete-input").attr("autocomplete","off");
this._on(this.element,{keydown:function(J){if(this.element.prop("readOnly")){F=true;
G=true;
D=true;
return 
}F=false;
G=false;
D=false;
var K=A.ui.keyCode;
switch(J.keyCode){case K.PAGE_UP:F=true;
this._move("previousPage",J);
break;
case K.PAGE_DOWN:F=true;
this._move("nextPage",J);
break;
case K.UP:F=true;
this._keyEvent("previous",J);
break;
case K.DOWN:F=true;
this._keyEvent("next",J);
break;
case K.ENTER:case K.NUMPAD_ENTER:if(this.menu.active){F=true;
J.preventDefault();
this.menu.select(J)
}break;
case K.TAB:if(this.menu.active){this.menu.select(J)
}break;
case K.ESCAPE:if(this.menu.element.is(":visible")){this._value(this.term);
this.close(J);
J.preventDefault()
}break;
default:D=true;
this._searchTimeout(J);
break
}},keypress:function(J){if(F){F=false;
if(!this.isMultiLine||this.menu.element.is(":visible")){J.preventDefault()
}return 
}if(D){return 
}var K=A.ui.keyCode;
switch(J.keyCode){case K.PAGE_UP:this._move("previousPage",J);
break;
case K.PAGE_DOWN:this._move("nextPage",J);
break;
case K.UP:this._keyEvent("previous",J);
break;
case K.DOWN:this._keyEvent("next",J);
break
}},input:function(J){if(G){G=false;
J.preventDefault();
return 
}this._searchTimeout(J)
},focus:function(){this.selectedItem=null;
this.previous=this._value()
},blur:function(J){if(this.cancelBlur){delete this.cancelBlur;
return 
}clearTimeout(this.searching);
this.close(J);
this._change(J)
}});
this._initSource();
this.menu=A("<ul>").addClass("ui-autocomplete ui-front").appendTo(this._appendTo()).menu({role:null}).hide().data("ui-menu");
this._on(this.menu.element,{mousedown:function(J){J.preventDefault();
this.cancelBlur=true;
this._delay(function(){delete this.cancelBlur
});
var K=this.menu.element[0];
if(!A(J.target).closest(".ui-menu-item").length){this._delay(function(){var L=this;
this.document.one("mousedown",function(M){if(M.target!==L.element[0]&&M.target!==K&&!A.contains(K,M.target)){L.close()
}})
})
}},menufocus:function(K,L){if(this.isNewMenu){this.isNewMenu=false;
if(K.originalEvent&&/^mouse/.test(K.originalEvent.type)){this.menu.blur();
this.document.one("mousemove",function(){A(K.target).trigger(K.originalEvent)
});
return 
}}var J=L.item.data("ui-autocomplete-item");
if(false!==this._trigger("focus",K,{item:J})){if(K.originalEvent&&/^key/.test(K.originalEvent.type)){this._value(J.value)
}}else{this.liveRegion.text(J.value)
}},menuselect:function(L,M){var K=M.item.data("ui-autocomplete-item"),J=this.previous;
if(this.element[0]!==this.document[0].activeElement){this.element.focus();
this.previous=J;
this._delay(function(){this.previous=J;
this.selectedItem=K
})
}if(false!==this._trigger("select",L,{item:K})){this._value(K.value)
}this.term=this._value();
this.close(L);
this.selectedItem=K
}});
this.liveRegion=A("<span>",{role:"status","aria-live":"polite"}).addClass("ui-helper-hidden-accessible").insertBefore(this.element);
this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete")
}})
},_destroy:function(){clearTimeout(this.searching);
this.element.removeClass("ui-autocomplete-input").removeAttr("autocomplete");
this.menu.element.remove();
this.liveRegion.remove()
},_setOption:function(D,E){this._super(D,E);
if(D==="source"){this._initSource()
}if(D==="appendTo"){this.menu.element.appendTo(this._appendTo())
}if(D==="disabled"&&E&&this.xhr){this.xhr.abort()
}},_appendTo:function(){var D=this.options.appendTo;
if(D){D=D.jquery||D.nodeType?A(D):this.document.find(D).eq(0)
}if(!D){D=this.element.closest(".ui-front")
}if(!D.length){D=this.document[0].body
}return D
},_initSource:function(){var F,D,E=this;
if(A.isArray(this.options.source)){F=this.options.source;
this.source=function(H,G){G(A.ui.autocomplete.filter(F,H.term))
}
}else{if(typeof this.options.source==="string"){D=this.options.source;
this.source=function(H,G){if(E.xhr){E.xhr.abort()
}E.xhr=A.ajax({url:D,data:H,dataType:"json",success:function(I){G(I)
},error:function(){G([])
}})
}
}else{this.source=this.options.source
}}},_searchTimeout:function(D){clearTimeout(this.searching);
this.searching=this._delay(function(){if(this.term!==this._value()){this.selectedItem=null;
this.search(null,D)
}},this.options.delay)
},search:function(E,D){E=E!=null?E:this._value();
this.term=this._value();
if(E.length<this.options.minLength){return this.close(D)
}if(this._trigger("search",D)===false){return 
}return this._search(E)
},_search:function(D){this.pending++;
this.element.addClass("ui-autocomplete-loading");
this.cancelSearch=false;
this.source({term:D},this._response())
},_response:function(){var E=this,D=++C;
return function(F){if(D===C){E.__response(F)
}E.pending--;
if(!E.pending){E.element.removeClass("ui-autocomplete-loading")
}}
},__response:function(D){if(D){D=this._normalize(D)
}this._trigger("response",null,{content:D});
if(!this.options.disabled&&D&&D.length&&!this.cancelSearch){this._suggest(D);
this._trigger("open")
}else{this._close()
}},close:function(D){this.cancelSearch=true;
this._close(D)
},_close:function(D){if(this.menu.element.is(":visible")){this.menu.element.hide();
this.menu.blur();
this.isNewMenu=true;
this._trigger("close",D)
}},_change:function(D){if(this.previous!==this._value()){this._trigger("change",D,{item:this.selectedItem})
}},_normalize:function(D){if(D.length&&D[0].label&&D[0].value){return D
}return A.map(D,function(E){if(typeof E==="string"){return{label:E,value:E}
}return A.extend({label:E.label||E.value,value:E.value||E.label},E)
})
},_suggest:function(D){var E=this.menu.element.empty();
this._renderMenu(E,D);
this.isNewMenu=true;
this.menu.refresh();
E.show();
this._resizeMenu();
E.position(A.extend({of:this.element},this.options.position));
if(this.options.autoFocus){this.menu.next()
}},_resizeMenu:function(){var D=this.menu.element;
D.outerWidth(Math.max(D.width("").outerWidth()+1,this.element.outerWidth()))
},_renderMenu:function(E,D){var F=this;
A.each(D,function(G,H){F._renderItemData(E,H)
})
},_renderItemData:function(D,E){return this._renderItem(D,E).data("ui-autocomplete-item",E)
},_renderItem:function(D,E){return A("<li>").append(A("<a>").text(E.label)).appendTo(D)
},_move:function(E,D){if(!this.menu.element.is(":visible")){this.search(null,D);
return 
}if(this.menu.isFirstItem()&&/^previous/.test(E)||this.menu.isLastItem()&&/^next/.test(E)){this._value(this.term);
this.menu.blur();
return 
}this.menu[E](D)
},widget:function(){return this.menu.element
},_value:function(){return this.valueMethod.apply(this.element,arguments)
},_keyEvent:function(E,D){if(!this.isMultiLine||this.menu.element.is(":visible")){this._move(E,D);
D.preventDefault()
}}});
A.extend(A.ui.autocomplete,{escapeRegex:function(D){return D.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&")
},filter:function(F,D){var E=new RegExp(A.ui.autocomplete.escapeRegex(D),"i");
return A.grep(F,function(G){return E.test(G.label||G.value||G)
})
}});
A.widget("ui.autocomplete",A.ui.autocomplete,{options:{messages:{noResults:"No search results.",results:function(D){return D+(D>1?" results are":" result is")+" available, use up and down arrow keys to navigate."
}}},__response:function(E){var D;
this._superApply(arguments);
if(this.options.disabled||this.cancelSearch){return 
}if(E&&E.length){D=this.options.messages.results(E.length)
}else{D=this.options.messages.noResults
}this.liveRegion.text(D)
}})
}(jQuery));