/*
 * jQuery UI Sortable 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/sortable/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
(function(B,D){function A(F,E,G){return(F>E)&&(F<(E+G))
}function C(E){return(/left|right/).test(E.css("float"))||(/inline|table-cell/).test(E.css("display"))
}B.widget("ui.sortable",B.ui.mouse,{version:"1.10.3",widgetEventPrefix:"sort",ready:false,options:{appendTo:"parent",axis:false,connectWith:false,containment:false,cursor:"auto",cursorAt:false,dropOnEmpty:true,forcePlaceholderSize:false,forceHelperSize:false,grid:false,handle:false,helper:"original",items:"> *",opacity:false,placeholder:false,revert:false,scroll:true,scrollSensitivity:20,scrollSpeed:20,scope:"default",tolerance:"intersect",zIndex:1000,activate:null,beforeStop:null,change:null,deactivate:null,out:null,over:null,receive:null,remove:null,sort:null,start:null,stop:null,update:null},_create:function(){var E=this.options;
this.containerCache={};
this.element.addClass("ui-sortable");
this.refresh();
this.floating=this.items.length?E.axis==="x"||C(this.items[0].item):false;
this.offset=this.element.offset();
this._mouseInit();
this.ready=true
},_destroy:function(){this.element.removeClass("ui-sortable ui-sortable-disabled");
this._mouseDestroy();
for(var E=this.items.length-1;
E>=0;
E--){this.items[E].item.removeData(this.widgetName+"-item")
}return this
},_setOption:function(E,F){if(E==="disabled"){this.options[E]=F;
this.widget().toggleClass("ui-sortable-disabled",!!F)
}else{B.Widget.prototype._setOption.apply(this,arguments)
}},_mouseCapture:function(G,H){var E=null,I=false,F=this;
if(this.reverting){return false
}if(this.options.disabled||this.options.type==="static"){return false
}this._refreshItems(G);
B(G.target).parents().each(function(){if(B.data(this,F.widgetName+"-item")===F){E=B(this);
return false
}});
if(B.data(G.target,F.widgetName+"-item")===F){E=B(G.target)
}if(!E){return false
}if(this.options.handle&&!H){B(this.options.handle,E).find("*").addBack().each(function(){if(this===G.target){I=true
}});
if(!I){return false
}}this.currentItem=E;
this._removeCurrentsFromItems();
return true
},_mouseStart:function(H,I,F){var G,E,J=this.options;
this.currentContainer=this;
this.refreshPositions();
this.helper=this._createHelper(H);
this._cacheHelperProportions();
this._cacheMargins();
this.scrollParent=this.helper.scrollParent();
this.offset=this.currentItem.offset();
this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left};
B.extend(this.offset,{click:{left:H.pageX-this.offset.left,top:H.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()});
this.helper.css("position","absolute");
this.cssPosition=this.helper.css("position");
this.originalPosition=this._generatePosition(H);
this.originalPageX=H.pageX;
this.originalPageY=H.pageY;
(J.cursorAt&&this._adjustOffsetFromHelper(J.cursorAt));
this.domPosition={prev:this.currentItem.prev()[0],parent:this.currentItem.parent()[0]};
if(this.helper[0]!==this.currentItem[0]){this.currentItem.hide()
}this._createPlaceholder();
if(J.containment){this._setContainment()
}if(J.cursor&&J.cursor!=="auto"){E=this.document.find("body");
this.storedCursor=E.css("cursor");
E.css("cursor",J.cursor);
this.storedStylesheet=B("<style>*{ cursor: "+J.cursor+" !important; }</style>").appendTo(E)
}if(J.opacity){if(this.helper.css("opacity")){this._storedOpacity=this.helper.css("opacity")
}this.helper.css("opacity",J.opacity)
}if(J.zIndex){if(this.helper.css("zIndex")){this._storedZIndex=this.helper.css("zIndex")
}this.helper.css("zIndex",J.zIndex)
}if(this.scrollParent[0]!==document&&this.scrollParent[0].tagName!=="HTML"){this.overflowOffset=this.scrollParent.offset()
}this._trigger("start",H,this._uiHash());
if(!this._preserveHelperProportions){this._cacheHelperProportions()
}if(!F){for(G=this.containers.length-1;
G>=0;
G--){this.containers[G]._trigger("activate",H,this._uiHash(this))
}}if(B.ui.ddmanager){B.ui.ddmanager.current=this
}if(B.ui.ddmanager&&!J.dropBehaviour){B.ui.ddmanager.prepareOffsets(this,H)
}this.dragging=true;
this.helper.addClass("ui-sortable-helper");
this._mouseDrag(H);
return true
},_mouseDrag:function(I){var G,H,F,K,J=this.options,E=false;
this.position=this._generatePosition(I);
this.positionAbs=this._convertPositionTo("absolute");
if(!this.lastPositionAbs){this.lastPositionAbs=this.positionAbs
}if(this.options.scroll){if(this.scrollParent[0]!==document&&this.scrollParent[0].tagName!=="HTML"){if((this.overflowOffset.top+this.scrollParent[0].offsetHeight)-I.pageY<J.scrollSensitivity){this.scrollParent[0].scrollTop=E=this.scrollParent[0].scrollTop+J.scrollSpeed
}else{if(I.pageY-this.overflowOffset.top<J.scrollSensitivity){this.scrollParent[0].scrollTop=E=this.scrollParent[0].scrollTop-J.scrollSpeed
}}if((this.overflowOffset.left+this.scrollParent[0].offsetWidth)-I.pageX<J.scrollSensitivity){this.scrollParent[0].scrollLeft=E=this.scrollParent[0].scrollLeft+J.scrollSpeed
}else{if(I.pageX-this.overflowOffset.left<J.scrollSensitivity){this.scrollParent[0].scrollLeft=E=this.scrollParent[0].scrollLeft-J.scrollSpeed
}}}else{if(I.pageY-B(document).scrollTop()<J.scrollSensitivity){E=B(document).scrollTop(B(document).scrollTop()-J.scrollSpeed)
}else{if(B(window).height()-(I.pageY-B(document).scrollTop())<J.scrollSensitivity){E=B(document).scrollTop(B(document).scrollTop()+J.scrollSpeed)
}}if(I.pageX-B(document).scrollLeft()<J.scrollSensitivity){E=B(document).scrollLeft(B(document).scrollLeft()-J.scrollSpeed)
}else{if(B(window).width()-(I.pageX-B(document).scrollLeft())<J.scrollSensitivity){E=B(document).scrollLeft(B(document).scrollLeft()+J.scrollSpeed)
}}}if(E!==false&&B.ui.ddmanager&&!J.dropBehaviour){B.ui.ddmanager.prepareOffsets(this,I)
}}this.positionAbs=this._convertPositionTo("absolute");
if(!this.options.axis||this.options.axis!=="y"){this.helper[0].style.left=this.position.left+"px"
}if(!this.options.axis||this.options.axis!=="x"){this.helper[0].style.top=this.position.top+"px"
}for(G=this.items.length-1;
G>=0;
G--){H=this.items[G];
F=H.item[0];
K=this._intersectsWithPointer(H);
if(!K){continue
}if(H.instance!==this.currentContainer){continue
}if(F!==this.currentItem[0]&&this.placeholder[K===1?"next":"prev"]()[0]!==F&&!B.contains(this.placeholder[0],F)&&(this.options.type==="semi-dynamic"?!B.contains(this.element[0],F):true)){this.direction=K===1?"down":"up";
if(this.options.tolerance==="pointer"||this._intersectsWithSides(H)){this._rearrange(I,H)
}else{break
}this._trigger("change",I,this._uiHash());
break
}}this._contactContainers(I);
if(B.ui.ddmanager){B.ui.ddmanager.drag(this,I)
}this._trigger("sort",I,this._uiHash());
this.lastPositionAbs=this.positionAbs;
return false
},_mouseStop:function(G,I){if(!G){return 
}if(B.ui.ddmanager&&!this.options.dropBehaviour){B.ui.ddmanager.drop(this,G)
}if(this.options.revert){var F=this,J=this.placeholder.offset(),E=this.options.axis,H={};
if(!E||E==="x"){H.left=J.left-this.offset.parent.left-this.margins.left+(this.offsetParent[0]===document.body?0:this.offsetParent[0].scrollLeft)
}if(!E||E==="y"){H.top=J.top-this.offset.parent.top-this.margins.top+(this.offsetParent[0]===document.body?0:this.offsetParent[0].scrollTop)
}this.reverting=true;
B(this.helper).animate(H,parseInt(this.options.revert,10)||500,function(){F._clear(G)
})
}else{this._clear(G,I)
}return false
},cancel:function(){if(this.dragging){this._mouseUp({target:null});
if(this.options.helper==="original"){this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper")
}else{this.currentItem.show()
}for(var E=this.containers.length-1;
E>=0;
E--){this.containers[E]._trigger("deactivate",null,this._uiHash(this));
if(this.containers[E].containerCache.over){this.containers[E]._trigger("out",null,this._uiHash(this));
this.containers[E].containerCache.over=0
}}}if(this.placeholder){if(this.placeholder[0].parentNode){this.placeholder[0].parentNode.removeChild(this.placeholder[0])
}if(this.options.helper!=="original"&&this.helper&&this.helper[0].parentNode){this.helper.remove()
}B.extend(this,{helper:null,dragging:false,reverting:false,_noFinalSort:null});
if(this.domPosition.prev){B(this.domPosition.prev).after(this.currentItem)
}else{B(this.domPosition.parent).prepend(this.currentItem)
}}return this
},serialize:function(G){var E=this._getItemsAsjQuery(G&&G.connected),F=[];
G=G||{};
B(E).each(function(){var H=(B(G.item||this).attr(G.attribute||"id")||"").match(G.expression||(/(.+)[\-=_](.+)/));
if(H){F.push((G.key||H[1]+"[]")+"="+(G.key&&G.expression?H[1]:H[2]))
}});
if(!F.length&&G.key){F.push(G.key+"=")
}return F.join("&")
},toArray:function(G){var E=this._getItemsAsjQuery(G&&G.connected),F=[];
G=G||{};
E.each(function(){F.push(B(G.item||this).attr(G.attribute||"id")||"")
});
return F
},_intersectsWith:function(P){var G=this.positionAbs.left,F=G+this.helperProportions.width,N=this.positionAbs.top,M=N+this.helperProportions.height,H=P.left,E=H+P.width,Q=P.top,L=Q+P.height,R=this.offset.click.top,K=this.offset.click.left,J=(this.options.axis==="x")||((N+R)>Q&&(N+R)<L),O=(this.options.axis==="y")||((G+K)>H&&(G+K)<E),I=J&&O;
if(this.options.tolerance==="pointer"||this.options.forcePointerForContainers||(this.options.tolerance!=="pointer"&&this.helperProportions[this.floating?"width":"height"]>P[this.floating?"width":"height"])){return I
}else{return(H<G+(this.helperProportions.width/2)&&F-(this.helperProportions.width/2)<E&&Q<N+(this.helperProportions.height/2)&&M-(this.helperProportions.height/2)<L)
}},_intersectsWithPointer:function(G){var H=(this.options.axis==="x")||A(this.positionAbs.top+this.offset.click.top,G.top,G.height),F=(this.options.axis==="y")||A(this.positionAbs.left+this.offset.click.left,G.left,G.width),J=H&&F,E=this._getDragVerticalDirection(),I=this._getDragHorizontalDirection();
if(!J){return false
}return this.floating?(((I&&I==="right")||E==="down")?2:1):(E&&(E==="down"?2:1))
},_intersectsWithSides:function(H){var F=A(this.positionAbs.top+this.offset.click.top,H.top+(H.height/2),H.height),G=A(this.positionAbs.left+this.offset.click.left,H.left+(H.width/2),H.width),E=this._getDragVerticalDirection(),I=this._getDragHorizontalDirection();
if(this.floating&&I){return((I==="right"&&G)||(I==="left"&&!G))
}else{return E&&((E==="down"&&F)||(E==="up"&&!F))
}},_getDragVerticalDirection:function(){var E=this.positionAbs.top-this.lastPositionAbs.top;
return E!==0&&(E>0?"down":"up")
},_getDragHorizontalDirection:function(){var E=this.positionAbs.left-this.lastPositionAbs.left;
return E!==0&&(E>0?"right":"left")
},refresh:function(E){this._refreshItems(E);
this.refreshPositions();
return this
},_connectWith:function(){var E=this.options;
return E.connectWith.constructor===String?[E.connectWith]:E.connectWith
},_getItemsAsjQuery:function(J){var H,G,L,K,E=[],F=[],I=this._connectWith();
if(I&&J){for(H=I.length-1;
H>=0;
H--){L=B(I[H]);
for(G=L.length-1;
G>=0;
G--){K=B.data(L[G],this.widgetFullName);
if(K&&K!==this&&!K.options.disabled){F.push([B.isFunction(K.options.items)?K.options.items.call(K.element):B(K.options.items,K.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),K])
}}}}F.push([B.isFunction(this.options.items)?this.options.items.call(this.element,null,{options:this.options,item:this.currentItem}):B(this.options.items,this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),this]);
for(H=F.length-1;
H>=0;
H--){F[H][0].each(function(){E.push(this)
})
}return B(E)
},_removeCurrentsFromItems:function(){var E=this.currentItem.find(":data("+this.widgetName+"-item)");
this.items=B.grep(this.items,function(G){for(var F=0;
F<E.length;
F++){if(E[F]===G.item[0]){return false
}}return true
})
},_refreshItems:function(E){this.items=[];
this.containers=[this];
var I,G,N,J,M,F,P,O,K=this.items,H=[[B.isFunction(this.options.items)?this.options.items.call(this.element[0],E,{item:this.currentItem}):B(this.options.items,this.element),this]],L=this._connectWith();
if(L&&this.ready){for(I=L.length-1;
I>=0;
I--){N=B(L[I]);
for(G=N.length-1;
G>=0;
G--){J=B.data(N[G],this.widgetFullName);
if(J&&J!==this&&!J.options.disabled){H.push([B.isFunction(J.options.items)?J.options.items.call(J.element[0],E,{item:this.currentItem}):B(J.options.items,J.element),J]);
this.containers.push(J)
}}}}for(I=H.length-1;
I>=0;
I--){M=H[I][1];
F=H[I][0];
for(G=0,O=F.length;
G<O;
G++){P=B(F[G]);
P.data(this.widgetName+"-item",M);
K.push({item:P,instance:M,width:0,height:0,left:0,top:0})
}}},refreshPositions:function(E){if(this.offsetParent&&this.helper){this.offset.parent=this._getParentOffset()
}var G,H,F,I;
for(G=this.items.length-1;
G>=0;
G--){H=this.items[G];
if(H.instance!==this.currentContainer&&this.currentContainer&&H.item[0]!==this.currentItem[0]){continue
}F=this.options.toleranceElement?B(this.options.toleranceElement,H.item):H.item;
if(!E){H.width=F.outerWidth();
H.height=F.outerHeight()
}I=F.offset();
H.left=I.left;
H.top=I.top
}if(this.options.custom&&this.options.custom.refreshContainers){this.options.custom.refreshContainers.call(this)
}else{for(G=this.containers.length-1;
G>=0;
G--){I=this.containers[G].element.offset();
this.containers[G].containerCache.left=I.left;
this.containers[G].containerCache.top=I.top;
this.containers[G].containerCache.width=this.containers[G].element.outerWidth();
this.containers[G].containerCache.height=this.containers[G].element.outerHeight()
}}return this
},_createPlaceholder:function(F){F=F||this;
var E,G=F.options;
if(!G.placeholder||G.placeholder.constructor===String){E=G.placeholder;
G.placeholder={element:function(){var I=F.currentItem[0].nodeName.toLowerCase(),H=B("<"+I+">",F.document[0]).addClass(E||F.currentItem[0].className+" ui-sortable-placeholder").removeClass("ui-sortable-helper");
if(I==="tr"){F.currentItem.children().each(function(){B("<td>&#160;</td>",F.document[0]).attr("colspan",B(this).attr("colspan")||1).appendTo(H)
})
}else{if(I==="img"){H.attr("src",F.currentItem.attr("src"))
}}if(!E){H.css("visibility","hidden")
}return H
},update:function(H,I){if(E&&!G.forcePlaceholderSize){return 
}if(!I.height()){I.height(F.currentItem.innerHeight()-parseInt(F.currentItem.css("paddingTop")||0,10)-parseInt(F.currentItem.css("paddingBottom")||0,10))
}if(!I.width()){I.width(F.currentItem.innerWidth()-parseInt(F.currentItem.css("paddingLeft")||0,10)-parseInt(F.currentItem.css("paddingRight")||0,10))
}}}
}F.placeholder=B(G.placeholder.element.call(F.element,F.currentItem));
F.currentItem.after(F.placeholder);
G.placeholder.update(F,F.placeholder)
},_contactContainers:function(E){var J,H,N,K,L,P,F,Q,I,M,G=null,O=null;
for(J=this.containers.length-1;
J>=0;
J--){if(B.contains(this.currentItem[0],this.containers[J].element[0])){continue
}if(this._intersectsWith(this.containers[J].containerCache)){if(G&&B.contains(this.containers[J].element[0],G.element[0])){continue
}G=this.containers[J];
O=J
}else{if(this.containers[J].containerCache.over){this.containers[J]._trigger("out",E,this._uiHash(this));
this.containers[J].containerCache.over=0
}}}if(!G){return 
}if(this.containers.length===1){if(!this.containers[O].containerCache.over){this.containers[O]._trigger("over",E,this._uiHash(this));
this.containers[O].containerCache.over=1
}}else{N=10000;
K=null;
M=G.floating||C(this.currentItem);
L=M?"left":"top";
P=M?"width":"height";
F=this.positionAbs[L]+this.offset.click[L];
for(H=this.items.length-1;
H>=0;
H--){if(!B.contains(this.containers[O].element[0],this.items[H].item[0])){continue
}if(this.items[H].item[0]===this.currentItem[0]){continue
}if(M&&!A(this.positionAbs.top+this.offset.click.top,this.items[H].top,this.items[H].height)){continue
}Q=this.items[H].item.offset()[L];
I=false;
if(Math.abs(Q-F)>Math.abs(Q+this.items[H][P]-F)){I=true;
Q+=this.items[H][P]
}if(Math.abs(Q-F)<N){N=Math.abs(Q-F);
K=this.items[H];
this.direction=I?"up":"down"
}}if(!K&&!this.options.dropOnEmpty){return 
}if(this.currentContainer===this.containers[O]){return 
}K?this._rearrange(E,K,null,true):this._rearrange(E,null,this.containers[O].element,true);
this._trigger("change",E,this._uiHash());
this.containers[O]._trigger("change",E,this._uiHash(this));
this.currentContainer=this.containers[O];
this.options.placeholder.update(this.currentContainer,this.placeholder);
this.containers[O]._trigger("over",E,this._uiHash(this));
this.containers[O].containerCache.over=1
}},_createHelper:function(F){var G=this.options,E=B.isFunction(G.helper)?B(G.helper.apply(this.element[0],[F,this.currentItem])):(G.helper==="clone"?this.currentItem.clone():this.currentItem);
if(!E.parents("body").length){B(G.appendTo!=="parent"?G.appendTo:this.currentItem[0].parentNode)[0].appendChild(E[0])
}if(E[0]===this.currentItem[0]){this._storedCSS={width:this.currentItem[0].style.width,height:this.currentItem[0].style.height,position:this.currentItem.css("position"),top:this.currentItem.css("top"),left:this.currentItem.css("left")}
}if(!E[0].style.width||G.forceHelperSize){E.width(this.currentItem.width())
}if(!E[0].style.height||G.forceHelperSize){E.height(this.currentItem.height())
}return E
},_adjustOffsetFromHelper:function(E){if(typeof E==="string"){E=E.split(" ")
}if(B.isArray(E)){E={left:+E[0],top:+E[1]||0}
}if("left" in E){this.offset.click.left=E.left+this.margins.left
}if("right" in E){this.offset.click.left=this.helperProportions.width-E.right+this.margins.left
}if("top" in E){this.offset.click.top=E.top+this.margins.top
}if("bottom" in E){this.offset.click.top=this.helperProportions.height-E.bottom+this.margins.top
}},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();
var E=this.offsetParent.offset();
if(this.cssPosition==="absolute"&&this.scrollParent[0]!==document&&B.contains(this.scrollParent[0],this.offsetParent[0])){E.left+=this.scrollParent.scrollLeft();
E.top+=this.scrollParent.scrollTop()
}if(this.offsetParent[0]===document.body||(this.offsetParent[0].tagName&&this.offsetParent[0].tagName.toLowerCase()==="html"&&B.ui.ie)){E={top:0,left:0}
}return{top:E.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:E.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}
},_getRelativeOffset:function(){if(this.cssPosition==="relative"){var E=this.currentItem.position();
return{top:E.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:E.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()}
}else{return{top:0,left:0}
}},_cacheMargins:function(){this.margins={left:(parseInt(this.currentItem.css("marginLeft"),10)||0),top:(parseInt(this.currentItem.css("marginTop"),10)||0)}
},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}
},_setContainment:function(){var F,H,E,G=this.options;
if(G.containment==="parent"){G.containment=this.helper[0].parentNode
}if(G.containment==="document"||G.containment==="window"){this.containment=[0-this.offset.relative.left-this.offset.parent.left,0-this.offset.relative.top-this.offset.parent.top,B(G.containment==="document"?document:window).width()-this.helperProportions.width-this.margins.left,(B(G.containment==="document"?document:window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]
}if(!(/^(document|window|parent)$/).test(G.containment)){F=B(G.containment)[0];
H=B(G.containment).offset();
E=(B(F).css("overflow")!=="hidden");
this.containment=[H.left+(parseInt(B(F).css("borderLeftWidth"),10)||0)+(parseInt(B(F).css("paddingLeft"),10)||0)-this.margins.left,H.top+(parseInt(B(F).css("borderTopWidth"),10)||0)+(parseInt(B(F).css("paddingTop"),10)||0)-this.margins.top,H.left+(E?Math.max(F.scrollWidth,F.offsetWidth):F.offsetWidth)-(parseInt(B(F).css("borderLeftWidth"),10)||0)-(parseInt(B(F).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left,H.top+(E?Math.max(F.scrollHeight,F.offsetHeight):F.offsetHeight)-(parseInt(B(F).css("borderTopWidth"),10)||0)-(parseInt(B(F).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top]
}},_convertPositionTo:function(G,I){if(!I){I=this.position
}var F=G==="absolute"?1:-1,E=this.cssPosition==="absolute"&&!(this.scrollParent[0]!==document&&B.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,H=(/(html|body)/i).test(E[0].tagName);
return{top:(I.top+this.offset.relative.top*F+this.offset.parent.top*F-((this.cssPosition==="fixed"?-this.scrollParent.scrollTop():(H?0:E.scrollTop()))*F)),left:(I.left+this.offset.relative.left*F+this.offset.parent.left*F-((this.cssPosition==="fixed"?-this.scrollParent.scrollLeft():H?0:E.scrollLeft())*F))}
},_generatePosition:function(H){var J,I,K=this.options,G=H.pageX,F=H.pageY,E=this.cssPosition==="absolute"&&!(this.scrollParent[0]!==document&&B.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,L=(/(html|body)/i).test(E[0].tagName);
if(this.cssPosition==="relative"&&!(this.scrollParent[0]!==document&&this.scrollParent[0]!==this.offsetParent[0])){this.offset.relative=this._getRelativeOffset()
}if(this.originalPosition){if(this.containment){if(H.pageX-this.offset.click.left<this.containment[0]){G=this.containment[0]+this.offset.click.left
}if(H.pageY-this.offset.click.top<this.containment[1]){F=this.containment[1]+this.offset.click.top
}if(H.pageX-this.offset.click.left>this.containment[2]){G=this.containment[2]+this.offset.click.left
}if(H.pageY-this.offset.click.top>this.containment[3]){F=this.containment[3]+this.offset.click.top
}}if(K.grid){J=this.originalPageY+Math.round((F-this.originalPageY)/K.grid[1])*K.grid[1];
F=this.containment?((J-this.offset.click.top>=this.containment[1]&&J-this.offset.click.top<=this.containment[3])?J:((J-this.offset.click.top>=this.containment[1])?J-K.grid[1]:J+K.grid[1])):J;
I=this.originalPageX+Math.round((G-this.originalPageX)/K.grid[0])*K.grid[0];
G=this.containment?((I-this.offset.click.left>=this.containment[0]&&I-this.offset.click.left<=this.containment[2])?I:((I-this.offset.click.left>=this.containment[0])?I-K.grid[0]:I+K.grid[0])):I
}}return{top:(F-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+((this.cssPosition==="fixed"?-this.scrollParent.scrollTop():(L?0:E.scrollTop())))),left:(G-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+((this.cssPosition==="fixed"?-this.scrollParent.scrollLeft():L?0:E.scrollLeft())))}
},_rearrange:function(I,H,F,G){F?F[0].appendChild(this.placeholder[0]):H.item[0].parentNode.insertBefore(this.placeholder[0],(this.direction==="down"?H.item[0]:H.item[0].nextSibling));
this.counter=this.counter?++this.counter:1;
var E=this.counter;
this._delay(function(){if(E===this.counter){this.refreshPositions(!G)
}})
},_clear:function(F,G){this.reverting=false;
var E,H=[];
if(!this._noFinalSort&&this.currentItem.parent().length){this.placeholder.before(this.currentItem)
}this._noFinalSort=null;
if(this.helper[0]===this.currentItem[0]){for(E in this._storedCSS){if(this._storedCSS[E]==="auto"||this._storedCSS[E]==="static"){this._storedCSS[E]=""
}}this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper")
}else{this.currentItem.show()
}if(this.fromOutside&&!G){H.push(function(I){this._trigger("receive",I,this._uiHash(this.fromOutside))
})
}if((this.fromOutside||this.domPosition.prev!==this.currentItem.prev().not(".ui-sortable-helper")[0]||this.domPosition.parent!==this.currentItem.parent()[0])&&!G){H.push(function(I){this._trigger("update",I,this._uiHash())
})
}if(this!==this.currentContainer){if(!G){H.push(function(I){this._trigger("remove",I,this._uiHash())
});
H.push((function(I){return function(J){I._trigger("receive",J,this._uiHash(this))
}
}).call(this,this.currentContainer));
H.push((function(I){return function(J){I._trigger("update",J,this._uiHash(this))
}
}).call(this,this.currentContainer))
}}for(E=this.containers.length-1;
E>=0;
E--){if(!G){H.push((function(I){return function(J){I._trigger("deactivate",J,this._uiHash(this))
}
}).call(this,this.containers[E]))
}if(this.containers[E].containerCache.over){H.push((function(I){return function(J){I._trigger("out",J,this._uiHash(this))
}
}).call(this,this.containers[E]));
this.containers[E].containerCache.over=0
}}if(this.storedCursor){this.document.find("body").css("cursor",this.storedCursor);
this.storedStylesheet.remove()
}if(this._storedOpacity){this.helper.css("opacity",this._storedOpacity)
}if(this._storedZIndex){this.helper.css("zIndex",this._storedZIndex==="auto"?"":this._storedZIndex)
}this.dragging=false;
if(this.cancelHelperRemoval){if(!G){this._trigger("beforeStop",F,this._uiHash());
for(E=0;
E<H.length;
E++){H[E].call(this,F)
}this._trigger("stop",F,this._uiHash())
}this.fromOutside=false;
return false
}if(!G){this._trigger("beforeStop",F,this._uiHash())
}this.placeholder[0].parentNode.removeChild(this.placeholder[0]);
if(this.helper[0]!==this.currentItem[0]){this.helper.remove()
}this.helper=null;
if(!G){for(E=0;
E<H.length;
E++){H[E].call(this,F)
}this._trigger("stop",F,this._uiHash())
}this.fromOutside=false;
return true
},_trigger:function(){if(B.Widget.prototype._trigger.apply(this,arguments)===false){this.cancel()
}},_uiHash:function(E){var F=E||this;
return{helper:F.helper,placeholder:F.placeholder||B([]),position:F.position,originalPosition:F.originalPosition,offset:F.positionAbs,item:F.currentItem,sender:E?E.element:null}
}})
})(jQuery);