/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractTermsParametersParser;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.internal.SearchContext;

public class TermsParametersParser
extends AbstractTermsParametersParser {
    private static final TermsAggregator.BucketCountThresholds DEFAULT_BUCKET_COUNT_THRESHOLDS = new TermsAggregator.BucketCountThresholds(1L, 0L, 10, -1);
    List<OrderElement> orderElements = new ArrayList<OrderElement>(1);
    private boolean showTermDocCountError = false;

    public List<OrderElement> getOrderElements() {
        return this.orderElements;
    }

    public boolean showTermDocCountError() {
        return this.showTermDocCountError;
    }

    public TermsParametersParser() {
        this.orderElements.add(new OrderElement("_count", false));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void parseSpecial(String aggregationName, XContentParser parser, SearchContext context, XContentParser.Token token, String currentFieldName) throws IOException {
        if (token == XContentParser.Token.START_OBJECT) {
            if (!"order".equals(currentFieldName)) throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            this.orderElements = Collections.singletonList(this.parseOrderParam(aggregationName, parser, context));
            return;
        } else if (token == XContentParser.Token.START_ARRAY) {
            if (!"order".equals(currentFieldName)) throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            this.orderElements = new ArrayList<OrderElement>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token != XContentParser.Token.START_OBJECT) throw new SearchParseException(context, "Order elements must be of type object in [" + aggregationName + "].");
                OrderElement orderParam = this.parseOrderParam(aggregationName, parser, context);
                this.orderElements.add(orderParam);
            }
            return;
        } else {
            if (token != XContentParser.Token.VALUE_BOOLEAN) throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            if (!SHOW_TERM_DOC_COUNT_ERROR.match(currentFieldName)) return;
            this.showTermDocCountError = parser.booleanValue();
        }
    }

    private OrderElement parseOrderParam(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        OrderElement orderParam = null;
        String orderKey = null;
        boolean orderAsc = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                orderKey = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                String dir = parser.text();
                if ("asc".equalsIgnoreCase(dir)) {
                    orderAsc = true;
                    continue;
                }
                if ("desc".equalsIgnoreCase(dir)) {
                    orderAsc = false;
                    continue;
                }
                throw new SearchParseException(context, "Unknown terms order direction [" + dir + "] in terms aggregation [" + aggregationName + "]");
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " for [order] in [" + aggregationName + "].");
        }
        if (orderKey == null) {
            throw new SearchParseException(context, "Must specify at least one field for [order] in [" + aggregationName + "].");
        }
        orderParam = new OrderElement(orderKey, orderAsc);
        return orderParam;
    }

    @Override
    public TermsAggregator.BucketCountThresholds getDefaultBucketCountThresholds() {
        return new TermsAggregator.BucketCountThresholds(DEFAULT_BUCKET_COUNT_THRESHOLDS);
    }

    static class OrderElement {
        private final String key;
        private final boolean asc;

        public OrderElement(String key, boolean asc) {
            this.key = key;
            this.asc = asc;
        }

        public String key() {
            return this.key;
        }

        public boolean asc() {
            return this.asc;
        }
    }
}

