/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.transport.TransportRequest;

class RecoveryTranslogOperationsRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private List<Translog.Operation> operations;
    private int totalTranslogOps = -1;

    RecoveryTranslogOperationsRequest() {
    }

    RecoveryTranslogOperationsRequest(long recoveryId, ShardId shardId, List<Translog.Operation> operations, int totalTranslogOps) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.operations = operations;
        this.totalTranslogOps = totalTranslogOps;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public List<Translog.Operation> operations() {
        return this.operations;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        int size = in.readVInt();
        this.operations = Lists.newArrayListWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
                this.operations.add(TranslogStreams.CHECKSUMMED_TRANSLOG_STREAM.read(in));
                continue;
            }
            this.operations.add(TranslogStreams.LEGACY_TRANSLOG_STREAM.read(in));
        }
        if (in.getVersion().onOrAfter(Version.V_1_5_0)) {
            this.totalTranslogOps = in.readVInt();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeVInt(this.operations.size());
        for (Translog.Operation operation : this.operations) {
            if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
                TranslogStreams.CHECKSUMMED_TRANSLOG_STREAM.write(out, operation);
                continue;
            }
            TranslogStreams.LEGACY_TRANSLOG_STREAM.write(out, operation);
        }
        if (out.getVersion().onOrAfter(Version.V_1_5_0)) {
            out.writeVInt(this.totalTranslogOps);
        }
    }
}

