/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesLifecycle;

public class InternalIndicesLifecycle
extends AbstractComponent
implements IndicesLifecycle {
    private final CopyOnWriteArrayList<IndicesLifecycle.Listener> listeners = new CopyOnWriteArrayList();

    @Inject
    public InternalIndicesLifecycle(Settings settings) {
        super(settings);
    }

    @Override
    public void addListener(IndicesLifecycle.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IndicesLifecycle.Listener listener) {
        this.listeners.remove(listener);
    }

    public void shardRoutingChanged(IndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.shardRoutingChanged(indexShard, oldRouting, newRouting);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke shard touring changed callback", t, indexShard.shardId());
            }
        }
    }

    public void beforeIndexAddedToCluster(Index index, @IndexSettings Settings indexSettings) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.beforeIndexAddedToCluster(index, indexSettings);
            }
            catch (Throwable t) {
                this.logger.warn("[{}] failed to invoke before index added to cluster callback", t, index.name());
                throw t;
            }
        }
    }

    public void beforeIndexCreated(Index index, @IndexSettings Settings indexSettings) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.beforeIndexCreated(index, indexSettings);
            }
            catch (Throwable t) {
                this.logger.warn("[{}] failed to invoke before index created callback", t, index.name());
                throw t;
            }
        }
    }

    public void afterIndexCreated(IndexService indexService) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexCreated(indexService);
            }
            catch (Throwable t) {
                this.logger.warn("[{}] failed to invoke after index created callback", t, indexService.index().name());
                throw t;
            }
        }
    }

    public void beforeIndexShardCreated(ShardId shardId, @IndexSettings Settings indexSettings) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.beforeIndexShardCreated(shardId, indexSettings);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke before shard created callback", t, shardId);
                throw t;
            }
        }
    }

    public void afterIndexShardCreated(IndexShard indexShard) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexShardCreated(indexShard);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke after shard created callback", t, indexShard.shardId());
                throw t;
            }
        }
    }

    public void afterIndexShardPostRecovery(IndexShard indexShard) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexShardPostRecovery(indexShard);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke after shard post recovery callback", t, indexShard.shardId());
                throw t;
            }
        }
    }

    public void afterIndexShardStarted(IndexShard indexShard) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexShardStarted(indexShard);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke after shard started callback", t, indexShard.shardId());
                throw t;
            }
        }
    }

    public void beforeIndexClosed(IndexService indexService) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.beforeIndexClosed(indexService);
            }
            catch (Throwable t) {
                this.logger.warn("[{}] failed to invoke before index closed callback", t, indexService.index().name());
                throw t;
            }
        }
    }

    public void beforeIndexDeleted(IndexService indexService) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.beforeIndexDeleted(indexService);
            }
            catch (Throwable t) {
                this.logger.warn("[{}] failed to invoke before index deleted callback", t, indexService.index().name());
                throw t;
            }
        }
    }

    public void afterIndexDeleted(Index index, @IndexSettings Settings indexSettings) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexDeleted(index, indexSettings);
            }
            catch (Throwable t) {
                this.logger.warn("[{}] failed to invoke after index deleted callback", t, index.name());
                throw t;
            }
        }
    }

    public void afterIndexClosed(Index index, @IndexSettings Settings indexSettings) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexClosed(index, indexSettings);
            }
            catch (Throwable t) {
                this.logger.warn("[{}] failed to invoke after index closed callback", t, index.name());
                throw t;
            }
        }
    }

    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, @IndexSettings Settings indexSettings) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.beforeIndexShardClosed(shardId, indexShard, indexSettings);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke before shard closed callback", t, shardId);
                throw t;
            }
        }
    }

    public void afterIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, @IndexSettings Settings indexSettings) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexShardClosed(shardId, indexShard, indexSettings);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke after shard closed callback", t, shardId);
                throw t;
            }
        }
    }

    public void beforeIndexShardDeleted(ShardId shardId, @IndexSettings Settings indexSettings) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.beforeIndexShardDeleted(shardId, indexSettings);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke before shard deleted callback", t, shardId);
                throw t;
            }
        }
    }

    public void afterIndexShardDeleted(ShardId shardId, @IndexSettings Settings indexSettings) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexShardDeleted(shardId, indexSettings);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke after shard deleted callback", t, shardId);
                throw t;
            }
        }
    }

    public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, @Nullable String reason) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.indexShardStateChanged(indexShard, previousState, indexShard.state(), reason);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke index shard state changed callback", t, indexShard.shardId());
                throw t;
            }
        }
    }
}

