/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.Callback;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.util.concurrent.RefCounted;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.DirectoryUtils;
import org.elasticsearch.index.store.DistributorDirectory;
import org.elasticsearch.index.store.LegacyVerification;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.store.VerifyingIndexOutput;
import org.elasticsearch.index.store.distributor.Distributor;

public class Store
extends AbstractIndexShardComponent
implements CloseableIndexComponent,
Closeable,
RefCounted {
    private static final String CODEC = "store";
    private static final int VERSION_STACK_TRACE = 1;
    private static final int VERSION_START = 0;
    private static final int VERSION = 1;
    private static final String CORRUPTED = "corrupted_";
    public static final String INDEX_STORE_STATS_REFRESH_INTERVAL = "index.store.stats_refresh_interval";
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final StoreDirectory directory;
    private final DistributorDirectory distributorDirectory;
    private final ReentrantReadWriteLock metadataLock = new ReentrantReadWriteLock();
    private final ShardLock shardLock;
    private final DirectoryService directoryService;
    private final OnClose onClose;
    private final SingleObjectCache<StoreStats> statsCache;
    private final AbstractRefCounted refCounter = new AbstractRefCounted("store"){

        @Override
        protected void closeInternal() {
            Store.this.closeInternal();
        }
    };
    public static final String CHECKSUMS_PREFIX = "_checksums-";

    public Store(ShardId shardId, @IndexSettings Settings indexSettings, DirectoryService directoryService, Distributor distributor, ShardLock shardLock) throws IOException {
        this(shardId, indexSettings, directoryService, distributor, shardLock, OnClose.EMPTY);
    }

    @Inject
    public Store(ShardId shardId, @IndexSettings Settings indexSettings, DirectoryService directoryService, Distributor distributor, ShardLock shardLock, OnClose onClose) throws IOException {
        super(shardId, indexSettings);
        this.directoryService = directoryService;
        this.directory = new StoreDirectory(directoryService.newFromDistributor(distributor));
        this.distributorDirectory = DirectoryUtils.getLeaf((Directory)this.directory, DistributorDirectory.class);
        this.shardLock = shardLock;
        this.onClose = onClose;
        TimeValue refreshInterval = indexSettings.getAsTime(INDEX_STORE_STATS_REFRESH_INTERVAL, TimeValue.timeValueSeconds(10L));
        this.statsCache = new StoreStatsCache(refreshInterval, (Directory)this.directory, directoryService);
        this.logger.debug("store stats are refreshed with refresh_interval [{}]", refreshInterval);
        assert (onClose != null);
        assert (shardLock != null);
        assert (shardLock.getShardId().equals(shardId));
    }

    public Directory directory() {
        this.ensureOpen();
        return this.directory;
    }

    public SegmentInfos readLastCommittedSegmentsInfo() throws IOException {
        return Store.readSegmentsInfo(null, this.directory());
    }

    private static SegmentInfos readSegmentsInfo(IndexCommit commit, Directory directory) throws IOException {
        try {
            return commit == null ? Lucene.readSegmentInfos(directory) : Lucene.readSegmentInfos(commit, directory);
        }
        catch (EOFException eof) {
            throw new CorruptIndexException("Read past EOF while reading segment infos", (Throwable)eof);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception ex) {
            throw new CorruptIndexException("Hit unexpected exception while reading segment infos", (Throwable)ex);
        }
    }

    final void ensureOpen() {
        if (this.refCounter.refCount() <= 0) {
            throw new AlreadyClosedException("store is already closed");
        }
    }

    public MetadataSnapshot getMetadataOrEmpty() throws IOException {
        try {
            return this.getMetadata(null);
        }
        catch (IndexNotFoundException indexNotFoundException) {
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            this.logger.info("Failed to open / find files while reading metadata snapshot", new Object[0]);
        }
        return MetadataSnapshot.EMPTY;
    }

    public MetadataSnapshot getMetadata() throws IOException {
        return this.getMetadata(null);
    }

    public MetadataSnapshot getMetadata(IndexCommit commit) throws IOException {
        this.ensureOpen();
        this.failIfCorrupted();
        this.metadataLock.readLock().lock();
        try {
            MetadataSnapshot metadataSnapshot = new MetadataSnapshot(commit, (Directory)this.directory, this.logger);
            return metadataSnapshot;
        }
        catch (CorruptIndexException ex) {
            this.markStoreCorrupted(ex);
            throw ex;
        }
        finally {
            this.metadataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTempFilesSafe(Map<String, String> tempFileMap) throws IOException {
        Object[] entries = tempFileMap.entrySet().toArray(new Map.Entry[tempFileMap.size()]);
        ArrayUtil.timSort((Object[])entries, (Comparator)new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                String left = o1.getValue();
                String right = o2.getValue();
                if (left.startsWith("segments") || right.startsWith("segments")) {
                    if (!left.startsWith("segments")) {
                        return -1;
                    }
                    if (!right.startsWith("segments")) {
                        return 1;
                    }
                }
                return left.compareTo(right);
            }
        });
        this.metadataLock.writeLock().lock();
        try (Lock writeLock = this.directory.makeLock("write.lock");){
            if (!writeLock.obtain(IndexWriterConfig.getDefaultWriteLockTimeout())) {
                throw new LockObtainFailedException("Index locked for write: " + writeLock);
            }
            for (Object entry : entries) {
                String tempFile = (String)entry.getKey();
                String origFile = (String)entry.getValue();
                try {
                    this.directory.deleteFile(origFile);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                }
                catch (Throwable ex) {
                    this.logger.trace("failed to delete file [{}] (it may be missing, which is OK)", ex, origFile);
                }
                this.renameFile(tempFile, origFile);
                String remove = tempFileMap.remove(tempFile);
                assert (remove != null);
            }
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public StoreStats stats() throws IOException {
        this.ensureOpen();
        return this.statsCache.getOrRefresh();
    }

    public void renameFile(String from, String to) throws IOException {
        this.ensureOpen();
        if (this.distributorDirectory != null) {
            this.distributorDirectory.renameFile(this.directoryService, from, to);
        } else {
            this.directoryService.renameFile((Directory)this.directory, from, to);
        }
    }

    @Override
    public final void incRef() {
        this.refCounter.incRef();
    }

    @Override
    public final boolean tryIncRef() {
        return this.refCounter.tryIncRef();
    }

    @Override
    public final void decRef() {
        this.refCounter.decRef();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.decRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal() {
        try {
            try {
                this.directory.innerClose();
            }
            finally {
                this.onClose.handle(this.shardLock);
            }
        }
        catch (IOException e) {
            try {
                this.logger.debug("failed to close directory", e, new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.shardLock});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.shardLock});
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.shardLock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataSnapshot readMetadataSnapshot(File[] indexLocations, ESLogger logger) throws IOException {
        Directory[] dirs = new Directory[indexLocations.length];
        try {
            for (int i = 0; i < indexLocations.length; ++i) {
                dirs[i] = new SimpleFSDirectory(indexLocations[i]);
            }
            DistributorDirectory dir = new DistributorDirectory(dirs);
            Store.failIfCorrupted((Directory)dir, new ShardId("", 1));
            MetadataSnapshot metadataSnapshot = new MetadataSnapshot(null, (Directory)dir, logger);
            return metadataSnapshot;
        }
        catch (IndexNotFoundException dir) {
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            logger.info("Failed to open / find files while reading metadata snapshot", new Object[0]);
        }
        finally {
            IOUtils.close((Closeable[])dirs);
        }
        return MetadataSnapshot.EMPTY;
    }

    static boolean isUnreliableLegacyChecksum(StoreFileMetaData metadata) {
        if (metadata.hasLegacyChecksum()) {
            boolean badTermInfo = metadata.name().endsWith(".tii") || metadata.name().endsWith(".tis");
            boolean badCFS = metadata.name().endsWith(".cfs") && (metadata.writtenBy() == null || !metadata.writtenBy().onOrAfter(org.apache.lucene.util.Version.LUCENE_34));
            boolean badCommit = metadata.name().startsWith("segments");
            return badTermInfo || badCFS || badCommit;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IndexOutput createVerifyingOutput(String fileName, StoreFileMetaData metadata, IOContext context) throws IOException {
        IndexOutput output = this.directory().createOutput(fileName, context);
        boolean success = false;
        try {
            if (metadata.hasLegacyChecksum()) {
                if (Store.isUnreliableLegacyChecksum(metadata)) {
                    this.logger.debug("create legacy length-only output for non-write-once file {}", fileName);
                    return new LegacyVerification.LengthVerifyingIndexOutput(output, metadata.name(), metadata.length());
                }
                this.logger.debug("create legacy adler32 output for {}", fileName);
                return new LegacyVerification.Adler32VerifyingIndexOutput(output, metadata.name(), metadata.checksum(), metadata.length());
            }
            if (metadata.checksum() == null) {
                this.logger.debug("create legacy length-only output for {}", fileName);
                return new LegacyVerification.LengthVerifyingIndexOutput(output, metadata.name(), metadata.length());
            }
            assert (metadata.writtenBy() != null);
            if ($assertionsDisabled) return new LuceneVerifyingIndexOutput(metadata, output);
            if (metadata.writtenBy().onOrAfter(org.apache.lucene.util.Version.LUCENE_48)) return new LuceneVerifyingIndexOutput(metadata, output);
            throw new AssertionError();
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
            throw throwable;
        }
    }

    public static void verify(IndexOutput output) throws IOException {
        if (output instanceof VerifyingIndexOutput) {
            ((VerifyingIndexOutput)output).verify();
        }
    }

    public IndexInput openVerifyingInput(String filename, IOContext context, StoreFileMetaData metadata) throws IOException {
        if (metadata.hasLegacyChecksum() || metadata.checksum() == null) {
            this.logger.debug("open legacy input for {}", filename);
            return this.directory().openInput(filename, context);
        }
        assert (metadata.writtenBy() != null);
        assert (metadata.writtenBy().onOrAfter(org.apache.lucene.util.Version.LUCENE_48));
        return new VerifyingIndexInput(this.directory().openInput(filename, context));
    }

    public static void verify(IndexInput input) throws IOException {
        if (input instanceof VerifyingIndexInput) {
            ((VerifyingIndexInput)input).verify();
        }
    }

    public boolean checkIntegrity(StoreFileMetaData md) {
        return Store.checkIntegrity(md, this.directory());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkIntegrity(StoreFileMetaData md, Directory directory) {
        try (IndexInput input = directory.openInput(md.name(), IOContext.READONCE);){
            int bytesToRead;
            if (input.length() != md.length()) {
                boolean bl = false;
                return bl;
            }
            if (md.writtenBy() != null && md.writtenBy().onOrAfter(org.apache.lucene.util.Version.LUCENE_48)) {
                boolean bl = Store.digestToString(CodecUtil.checksumEntireFile((IndexInput)input)).equals(md.checksum());
                return bl;
            }
            if (!md.hasLegacyChecksum()) return true;
            if (Store.isUnreliableLegacyChecksum(md)) return true;
            Adler32 checksum = new Adler32();
            byte[] buffer = new byte[md.length() > 4096L ? 4096 : (int)md.length()];
            long len = input.length();
            for (long read = 0L; len > read; read += (long)bytesToRead) {
                long bytesLeft = len - read;
                bytesToRead = bytesLeft < (long)buffer.length ? (int)bytesLeft : buffer.length;
                input.readBytes(buffer, 0, bytesToRead, false);
                checksum.update(buffer, 0, bytesToRead);
            }
            boolean bl = Store.digestToString(checksum.getValue()).equals(md.checksum());
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean isMarkedCorrupted() throws IOException {
        String[] files;
        this.ensureOpen();
        for (String file : files = this.directory().listAll()) {
            if (!file.startsWith(CORRUPTED)) continue;
            return true;
        }
        return false;
    }

    public void failIfCorrupted() throws IOException {
        this.ensureOpen();
        Store.failIfCorrupted((Directory)this.directory, this.shardId);
    }

    private static final void failIfCorrupted(Directory directory, ShardId shardId) throws IOException {
        String[] files = directory.listAll();
        ArrayList<CorruptIndexException> ex = new ArrayList<CorruptIndexException>();
        for (String file : files) {
            if (!file.startsWith(CORRUPTED)) continue;
            try (ChecksumIndexInput input = directory.openChecksumInput(file, IOContext.READONCE);){
                int version = CodecUtil.checkHeader((DataInput)input, (String)CODEC, (int)0, (int)1);
                String msg = input.readString();
                StringBuilder builder = new StringBuilder(shardId.toString());
                builder.append(" Preexisting corrupted index [");
                builder.append(file).append("] caused by: ");
                builder.append(msg);
                if (version == 1) {
                    builder.append(System.lineSeparator());
                    builder.append(input.readString());
                }
                ex.add(new CorruptIndexException(builder.toString()));
                CodecUtil.checkFooter((ChecksumIndexInput)input);
            }
        }
        if (!ex.isEmpty()) {
            ExceptionsHelper.rethrowAndSuppress(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(String reason, Set<String> filesToClean) throws IOException {
        this.failIfCorrupted();
        this.metadataLock.writeLock().lock();
        try (Lock writeLock = this.directory.makeLock("write.lock");){
            if (!writeLock.obtain(IndexWriterConfig.getDefaultWriteLockTimeout())) {
                throw new LockObtainFailedException("Index locked for write: " + writeLock);
            }
            StoreDirectory dir = this.directory;
            for (String existingFile : dir.listAll()) {
                if (existingFile.equals("write.lock") || Store.isChecksum(existingFile) || filesToClean.contains(existingFile)) continue;
                try {
                    this.logDeleteFile(reason, existingFile);
                    dir.deleteFile(existingFile);
                }
                catch (IOException ex) {
                    if (existingFile.startsWith("segments") || existingFile.equals("segments.gen")) {
                        throw new ElasticsearchIllegalStateException("Can't delete " + existingFile + " - cleanup failed", ex);
                    }
                    this.logger.debug("failed to delete file [{}]", ex, existingFile);
                }
            }
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAndVerify(String reason, MetadataSnapshot sourceMetaData) throws IOException {
        this.failIfCorrupted();
        this.metadataLock.writeLock().lock();
        try {
            this.cleanup(reason, sourceMetaData.asMap().keySet());
            MetadataSnapshot metadataOrEmpty = this.getMetadata();
            this.verifyAfterCleanup(sourceMetaData, metadataOrEmpty);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    final void verifyAfterCleanup(MetadataSnapshot sourceMetaData, MetadataSnapshot targetMetaData) {
        RecoveryDiff recoveryDiff = targetMetaData.recoveryDiff(sourceMetaData);
        if (recoveryDiff.identical.size() != recoveryDiff.size()) {
            if (recoveryDiff.missing.isEmpty()) {
                for (StoreFileMetaData meta : recoveryDiff.different) {
                    StoreFileMetaData local = targetMetaData.get(meta.name());
                    StoreFileMetaData remote = sourceMetaData.get(meta.name());
                    boolean same = local.isSame(remote);
                    boolean hashAndLengthEqual = local.checksum() == null && remote.checksum() == null && local.hash().equals((Object)remote.hash()) && local.length() == remote.length();
                    boolean consistent = hashAndLengthEqual || same;
                    if (consistent) continue;
                    this.logger.debug("Files are different on the recovery target: {} ", recoveryDiff);
                    throw new ElasticsearchIllegalStateException("local version: " + local + " is different from remote version after recovery: " + remote, null);
                }
            } else {
                this.logger.debug("Files are missing on the recovery target: {} ", recoveryDiff);
                throw new ElasticsearchIllegalStateException("Files are missing on the recovery target: [different=" + recoveryDiff.different + ", missing=" + recoveryDiff.missing + ']', null);
            }
        }
    }

    public int refCount() {
        return this.refCounter.refCount();
    }

    public void logDeleteFile(String message, String fileName) {
        Store.logDeleteFile(this.directory(), message, fileName);
    }

    public static void logDeleteFile(Directory dir, String message, String fileName) {
        assert (dir instanceof StoreDirectory);
        if (dir instanceof StoreDirectory) {
            ((StoreDirectory)dir).deletesLogger.trace("{}: delete file {}", message, fileName);
        }
    }

    public static final boolean isChecksum(String name) {
        return name.startsWith(CHECKSUMS_PREFIX) || name.endsWith(".cks");
    }

    public static String digestToString(long digest) {
        return Long.toString(digest, 36);
    }

    public void deleteQuiet(String ... files) {
        for (String file : files) {
            try {
                this.directory().deleteFile(file);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void markStoreCorrupted(CorruptIndexException exception) throws IOException {
        this.ensureOpen();
        if (!this.isMarkedCorrupted()) {
            String uuid = CORRUPTED + Strings.randomBase64UUID();
            try (IndexOutput output = this.directory().createOutput(uuid, IOContext.DEFAULT);){
                CodecUtil.writeHeader((DataOutput)output, (String)CODEC, (int)1);
                output.writeString(ExceptionsHelper.detailedMessage(exception, true, 0));
                output.writeString(ExceptionsHelper.stackTrace(exception));
                CodecUtil.writeFooter((IndexOutput)output);
            }
            catch (IOException ex) {
                this.logger.warn("Can't mark store as corrupted", ex, new Object[0]);
            }
            this.directory().sync(Collections.singleton(uuid));
        }
    }

    private static class StoreStatsCache
    extends SingleObjectCache<StoreStats> {
        private final Directory directory;
        private final DirectoryService directoryService;

        public StoreStatsCache(TimeValue refreshInterval, Directory directory, DirectoryService directoryService) throws IOException {
            super(refreshInterval, new StoreStats(StoreStatsCache.estimateSize(directory), directoryService.throttleTimeInNanos()));
            this.directory = directory;
            this.directoryService = directoryService;
        }

        @Override
        protected StoreStats refresh() {
            try {
                return new StoreStats(StoreStatsCache.estimateSize(this.directory), this.directoryService.throttleTimeInNanos());
            }
            catch (IOException ex) {
                throw new ElasticsearchException("failed to refresh store stats");
            }
        }

        private static long estimateSize(Directory directory) throws IOException {
            String[] files;
            long estimatedSize = 0L;
            for (String file : files = directory.listAll()) {
                try {
                    estimatedSize += directory.fileLength(file);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                    // empty catch block
                }
            }
            return estimatedSize;
        }
    }

    public static interface OnClose
    extends Callback<ShardLock> {
        public static final OnClose EMPTY = new OnClose(){

            @Override
            public void handle(ShardLock Lock2) {
            }
        };
    }

    static class VerifyingIndexInput
    extends ChecksumIndexInput {
        private final IndexInput input;
        private final Checksum digest;
        private final long checksumPosition;
        private final byte[] checksum = new byte[8];
        private long verifiedPosition = 0L;

        public VerifyingIndexInput(IndexInput input) {
            this(input, (Checksum)new BufferedChecksum((Checksum)new CRC32()));
        }

        public VerifyingIndexInput(IndexInput input, Checksum digest) {
            super("VerifyingIndexInput(" + input + ")");
            this.input = input;
            this.digest = digest;
            this.checksumPosition = input.length() - 8L;
        }

        public byte readByte() throws IOException {
            long pos = this.input.getFilePointer();
            byte b = this.input.readByte();
            if (++pos > this.verifiedPosition) {
                if (pos <= this.checksumPosition) {
                    this.digest.update(b);
                } else {
                    this.checksum[(int)(pos - this.checksumPosition - 1L)] = b;
                }
                this.verifiedPosition = pos;
            }
            return b;
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            long pos = this.input.getFilePointer();
            this.input.readBytes(b, offset, len);
            if (pos + (long)len > this.verifiedPosition) {
                int alreadyVerified = (int)Math.max(0L, this.verifiedPosition - pos);
                if (pos < this.checksumPosition) {
                    if (pos + (long)len < this.checksumPosition) {
                        this.digest.update(b, offset + alreadyVerified, len - alreadyVerified);
                    } else {
                        int checksumOffset = (int)(this.checksumPosition - pos);
                        if (checksumOffset - alreadyVerified > 0) {
                            this.digest.update(b, offset + alreadyVerified, checksumOffset - alreadyVerified);
                        }
                        System.arraycopy(b, offset + checksumOffset, this.checksum, 0, len - checksumOffset);
                    }
                } else {
                    assert (pos - this.checksumPosition < 8L);
                    System.arraycopy(b, offset, this.checksum, (int)(pos - this.checksumPosition), len);
                }
                this.verifiedPosition = pos + (long)len;
            }
        }

        public long getChecksum() {
            return this.digest.getValue();
        }

        public void seek(long pos) throws IOException {
            if (pos < this.verifiedPosition) {
                this.input.seek(pos);
            } else if (this.verifiedPosition > this.getFilePointer()) {
                this.input.seek(this.verifiedPosition);
                this.skipBytes(pos - this.verifiedPosition);
            } else {
                this.skipBytes(pos - this.getFilePointer());
            }
        }

        public void close() throws IOException {
            this.input.close();
        }

        public long getFilePointer() {
            return this.input.getFilePointer();
        }

        public long length() {
            return this.input.length();
        }

        public IndexInput clone() {
            throw new UnsupportedOperationException();
        }

        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getStoredChecksum() {
            return new ByteArrayDataInput(this.checksum).readLong();
        }

        public long verify() throws CorruptIndexException {
            long storedChecksum = this.getStoredChecksum();
            if (this.getChecksum() == storedChecksum) {
                return storedChecksum;
            }
            throw new CorruptIndexException("verification failed : calculated=" + Store.digestToString(this.getChecksum()) + " stored=" + Store.digestToString(storedChecksum));
        }
    }

    static class LuceneVerifyingIndexOutput
    extends VerifyingIndexOutput {
        private final StoreFileMetaData metadata;
        private long writtenBytes;
        private final long checksumPosition;
        private String actualChecksum;

        LuceneVerifyingIndexOutput(StoreFileMetaData metadata, IndexOutput out) {
            super(out, metadata.name());
            this.metadata = metadata;
            this.checksumPosition = metadata.length() - 8L;
        }

        @Override
        public void verify() throws IOException {
            if (this.metadata.checksum().equals(this.actualChecksum) && this.writtenBytes == this.metadata.length()) {
                return;
            }
            throw new CorruptIndexException("verification failed (hardware problem?) : expected=" + this.metadata.checksum() + " actual=" + this.actualChecksum + " writtenLength=" + this.writtenBytes + " expectedLength=" + this.metadata.length() + " (resource=" + this.metadata.toString() + ")");
        }

        @Override
        public void writeByte(byte b) throws IOException {
            if (this.writtenBytes++ == this.checksumPosition) {
                this.readAndCompareChecksum();
            }
            this.out.writeByte(b);
        }

        private void readAndCompareChecksum() throws IOException {
            this.actualChecksum = Store.digestToString(this.getChecksum());
            if (!this.metadata.checksum().equals(this.actualChecksum)) {
                throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + this.metadata.checksum() + " actual=" + this.actualChecksum + " (resource=" + this.metadata.toString() + ")");
            }
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            if (this.writtenBytes + (long)length > this.checksumPosition && this.actualChecksum == null) {
                assert (this.writtenBytes <= this.checksumPosition);
                int bytesToWrite = (int)(this.checksumPosition - this.writtenBytes);
                this.out.writeBytes(b, offset, bytesToWrite);
                this.readAndCompareChecksum();
                offset += bytesToWrite;
                length -= bytesToWrite;
                this.writtenBytes += (long)bytesToWrite;
            }
            this.out.writeBytes(b, offset, length);
            this.writtenBytes += (long)length;
        }
    }

    public static final class LegacyChecksums {
        private final Map<String, String> legacyChecksums = new HashMap<String, String>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(StoreFileMetaData metaData) throws IOException {
            if (metaData.hasLegacyChecksum()) {
                LegacyChecksums legacyChecksums = this;
                synchronized (legacyChecksums) {
                    this.legacyChecksums.put(metaData.name(), metaData.checksum());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void write(Store store) throws IOException {
            StoreDirectory storeDirectory = store.directory;
            synchronized (storeDirectory) {
                Tuple<Map<String, String>, Long> tuple = MetadataSnapshot.readLegacyChecksums((Directory)store.directory);
                tuple.v1().putAll(this.legacyChecksums);
                if (!tuple.v1().isEmpty()) {
                    this.writeChecksums((Directory)store.directory, tuple.v1(), tuple.v2());
                }
            }
        }

        synchronized void writeChecksums(Directory directory, Map<String, String> checksums, long lastVersion) throws IOException {
            long nextVersion = System.currentTimeMillis();
            while (nextVersion <= lastVersion) {
                nextVersion = System.currentTimeMillis();
            }
            String checksumName = Store.CHECKSUMS_PREFIX + nextVersion;
            try (IndexOutput output = directory.createOutput(checksumName, IOContext.DEFAULT);){
                output.writeInt(0);
                output.writeStringStringMap(checksums);
            }
            directory.sync(Collections.singleton(checksumName));
            MetadataSnapshot.cleanLegacyChecksums(directory, nextVersion);
        }

        public void clear() {
            this.legacyChecksums.clear();
        }

        public void remove(String name) {
            this.legacyChecksums.remove(name);
        }
    }

    public static final class RecoveryDiff {
        public final List<StoreFileMetaData> identical;
        public final List<StoreFileMetaData> different;
        public final List<StoreFileMetaData> missing;

        RecoveryDiff(List<StoreFileMetaData> identical, List<StoreFileMetaData> different, List<StoreFileMetaData> missing) {
            this.identical = identical;
            this.different = different;
            this.missing = missing;
        }

        public int size() {
            return this.identical.size() + this.different.size() + this.missing.size();
        }

        public String toString() {
            return "RecoveryDiff{identical=" + this.identical + ", different=" + this.different + ", missing=" + this.missing + '}';
        }
    }

    public static final class MetadataSnapshot
    implements Iterable<StoreFileMetaData>,
    Streamable {
        private static final ESLogger logger = Loggers.getLogger(MetadataSnapshot.class);
        private static final org.apache.lucene.util.Version FIRST_LUCENE_CHECKSUM_VERSION = org.apache.lucene.util.Version.LUCENE_48;
        private static final org.apache.lucene.util.Version FIRST_ES_CRC32_VERSION = Version.V_1_3_0.luceneVersion;
        private Map<String, StoreFileMetaData> metadata;
        public static final MetadataSnapshot EMPTY = new MetadataSnapshot();
        private static final String DEL_FILE_EXTENSION = "del";
        private static final String FIELD_INFOS_FILE_EXTENSION = "fnm";

        public MetadataSnapshot(Map<String, StoreFileMetaData> metadata) {
            this.metadata = metadata;
        }

        MetadataSnapshot() {
            this.metadata = Collections.emptyMap();
        }

        MetadataSnapshot(IndexCommit commit, Directory directory, ESLogger logger) throws IOException {
            this.metadata = this.buildMetadata(commit, directory, logger);
            assert (this.metadata.isEmpty() || this.numSegmentFiles() == 1) : "numSegmentFiles: " + this.numSegmentFiles();
        }

        private static final boolean useLuceneChecksum(org.apache.lucene.util.Version version, boolean hasLegacyChecksum) {
            return version.onOrAfter(FIRST_LUCENE_CHECKSUM_VERSION) && !hasLegacyChecksum || version.onOrAfter(FIRST_ES_CRC32_VERSION);
        }

        ImmutableMap<String, StoreFileMetaData> buildMetadata(IndexCommit commit, Directory directory, ESLogger logger) throws IOException {
            ImmutableMap.Builder<String, StoreFileMetaData> builder;
            block23: {
                builder = ImmutableMap.builder();
                Map<String, String> checksumMap = MetadataSnapshot.readLegacyChecksums(directory).v1();
                try {
                    long length;
                    SegmentInfos segmentCommitInfos = Store.readSegmentsInfo(commit, directory);
                    org.apache.lucene.util.Version maxVersion = org.apache.lucene.util.Version.LUCENE_3_0;
                    for (SegmentCommitInfo info : segmentCommitInfos) {
                        org.apache.lucene.util.Version version = info.info.getVersion();
                        if (version != null && version.onOrAfter(maxVersion)) {
                            maxVersion = version;
                        }
                        for (String file : info.files()) {
                            String legacyChecksum = checksumMap.get(file);
                            if (MetadataSnapshot.useLuceneChecksum(version, legacyChecksum != null)) {
                                MetadataSnapshot.checksumFromLuceneFile(directory, file, builder, logger, version, "si".equals(IndexFileNames.getExtension((String)file)));
                                continue;
                            }
                            builder.put(file, new StoreFileMetaData(file, directory.fileLength(file), legacyChecksum, null));
                        }
                    }
                    String segmentsFile = segmentCommitInfos.getSegmentsFileName();
                    String legacyChecksum = checksumMap.get(segmentsFile);
                    if (MetadataSnapshot.useLuceneChecksum(maxVersion, legacyChecksum != null)) {
                        MetadataSnapshot.checksumFromLuceneFile(directory, segmentsFile, builder, logger, maxVersion, true);
                        break block23;
                    }
                    BytesRefBuilder fileHash = new BytesRefBuilder();
                    try (IndexInput in = directory.openInput(segmentsFile, IOContext.READONCE);){
                        length = in.length();
                        MetadataSnapshot.hashFile(fileHash, new InputStreamIndexInput(in, length), length);
                    }
                    builder.put(segmentsFile, new StoreFileMetaData(segmentsFile, length, legacyChecksum, null, fileHash.get()));
                }
                catch (CorruptIndexException | IndexNotFoundException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    try {
                        logger.warn("failed to build store metadata. checking segment info integrity (with commit [{}])", ex, commit == null ? "no" : "yes");
                        Lucene.checkSegmentInfoIntegrity(directory);
                    }
                    catch (CorruptIndexException cex) {
                        cex.addSuppressed(ex);
                        throw cex;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw ex;
                }
            }
            return builder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static Tuple<Map<String, String>, Long> readLegacyChecksums(Directory directory) throws IOException {
            Directory directory2 = directory;
            synchronized (directory2) {
                long lastFound = -1L;
                for (String name : directory.listAll()) {
                    long current;
                    if (!Store.isChecksum(name) || (current = Long.parseLong(name.substring(Store.CHECKSUMS_PREFIX.length()))) <= lastFound) continue;
                    lastFound = current;
                }
                if (lastFound <= -1L) {
                    return new Tuple<Map<String, String>, Long>(new HashMap(), -1L);
                }
                try (IndexInput indexInput = directory.openInput(Store.CHECKSUMS_PREFIX + lastFound, IOContext.READONCE);){
                    indexInput.readInt();
                    Tuple<Map<String, String>, Long> tuple = new Tuple<Map<String, String>, Long>(indexInput.readStringStringMap(), lastFound);
                    return tuple;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void cleanLegacyChecksums(Directory directory, long newVersion) throws IOException {
            Directory directory2 = directory;
            synchronized (directory2) {
                for (String name : directory.listAll()) {
                    long current;
                    if (!Store.isChecksum(name) || (current = Long.parseLong(name.substring(Store.CHECKSUMS_PREFIX.length()))) >= newVersion) continue;
                    try {
                        directory.deleteFile(name);
                    }
                    catch (IOException ex) {
                        logger.debug("can't delete old checksum file [{}]", ex, name);
                    }
                }
            }
        }

        private static void checksumFromLuceneFile(Directory directory, String file, ImmutableMap.Builder<String, StoreFileMetaData> builder, ESLogger logger, org.apache.lucene.util.Version version, boolean readFileAsHash) throws IOException {
            BytesRefBuilder fileHash = new BytesRefBuilder();
            try (IndexInput in = directory.openInput(file, IOContext.READONCE);){
                String checksum;
                long length;
                try {
                    length = in.length();
                    if (length < (long)CodecUtil.footerLength()) {
                        throw new CorruptIndexException("Can't retrieve checksum from file: " + file + " file length must be >= " + CodecUtil.footerLength() + " but was: " + in.length());
                    }
                    if (readFileAsHash) {
                        VerifyingIndexInput verifyingIndexInput = new VerifyingIndexInput(in);
                        MetadataSnapshot.hashFile(fileHash, new InputStreamIndexInput((IndexInput)verifyingIndexInput, length), length);
                        checksum = Store.digestToString(verifyingIndexInput.verify());
                    } else {
                        checksum = Store.digestToString(CodecUtil.retrieveChecksum((IndexInput)in));
                    }
                }
                catch (Throwable ex) {
                    logger.debug("Can retrieve checksum from file [{}]", ex, file);
                    throw ex;
                }
                builder.put(file, new StoreFileMetaData(file, length, checksum, version, fileHash.get()));
            }
        }

        public static BytesRef hashFile(Directory directory, String file) throws IOException {
            BytesRefBuilder fileHash = new BytesRefBuilder();
            try (IndexInput in = directory.openInput(file, IOContext.READONCE);){
                MetadataSnapshot.hashFile(fileHash, new InputStreamIndexInput(in, in.length()), in.length());
            }
            return fileHash.get();
        }

        public static void hashFile(BytesRefBuilder fileHash, InputStream in, long size) throws IOException {
            int len = (int)Math.min(0x100000L, size);
            fileHash.grow(len);
            fileHash.setLength(len);
            int readBytes = Streams.readFully(in, fileHash.bytes(), 0, len);
            assert (readBytes == len) : Integer.toString(readBytes) + " != " + Integer.toString(len);
            assert (fileHash.length() == len) : Integer.toString(fileHash.length()) + " != " + Integer.toString(len);
        }

        @Override
        public Iterator<StoreFileMetaData> iterator() {
            return this.metadata.values().iterator();
        }

        public StoreFileMetaData get(String name) {
            return this.metadata.get(name);
        }

        public Map<String, StoreFileMetaData> asMap() {
            return this.metadata;
        }

        public RecoveryDiff recoveryDiff(MetadataSnapshot recoveryTargetSnapshot) {
            ImmutableList.Builder identical = ImmutableList.builder();
            ImmutableList.Builder different = ImmutableList.builder();
            ImmutableList.Builder missing = ImmutableList.builder();
            HashMap<String, ArrayList<StoreFileMetaData>> perSegment = new HashMap<String, ArrayList<StoreFileMetaData>>();
            ArrayList<StoreFileMetaData> perCommitStoreFiles = new ArrayList<StoreFileMetaData>();
            for (StoreFileMetaData meta : this) {
                if ("segments.gen".equals(meta.name())) continue;
                String string = IndexFileNames.parseSegmentName((String)meta.name());
                String extension = IndexFileNames.getExtension((String)meta.name());
                assert (!FIELD_INFOS_FILE_EXTENSION.equals(extension) || IndexFileNames.stripExtension((String)IndexFileNames.stripSegmentName((String)meta.name())).isEmpty()) : "FieldInfos are generational but updateable DV are not supported in elasticsearch";
                if ("segments".equals(string) || DEL_FILE_EXTENSION.equals(extension)) {
                    perCommitStoreFiles.add(meta);
                    continue;
                }
                ArrayList<StoreFileMetaData> perSegStoreFiles = (ArrayList<StoreFileMetaData>)perSegment.get(string);
                if (perSegStoreFiles == null) {
                    perSegStoreFiles = new ArrayList<StoreFileMetaData>();
                    perSegment.put(string, perSegStoreFiles);
                }
                perSegStoreFiles.add(meta);
            }
            ArrayList<StoreFileMetaData> identicalFiles = new ArrayList<StoreFileMetaData>();
            for (List list : Iterables.concat(perSegment.values(), Collections.singleton(perCommitStoreFiles))) {
                identicalFiles.clear();
                boolean consistent = true;
                for (StoreFileMetaData meta : list) {
                    StoreFileMetaData storeFileMetaData = recoveryTargetSnapshot.get(meta.name());
                    if (storeFileMetaData == null) {
                        consistent = false;
                        missing.add(meta);
                        continue;
                    }
                    if (!storeFileMetaData.isSame(meta)) {
                        consistent = false;
                        different.add(meta);
                        continue;
                    }
                    identicalFiles.add(meta);
                }
                if (consistent) {
                    identical.addAll(identicalFiles);
                    continue;
                }
                different.addAll(identicalFiles);
            }
            RecoveryDiff recoveryDiff = new RecoveryDiff((List<StoreFileMetaData>)((Object)identical.build()), (List<StoreFileMetaData>)((Object)different.build()), (List<StoreFileMetaData>)((Object)missing.build()));
            assert (recoveryDiff.size() == this.metadata.size() - (this.metadata.containsKey("segments.gen") ? 1 : 0)) : "some files are missing recoveryDiff size: [" + recoveryDiff.size() + "] metadata size: [" + this.metadata.size() + "] contains  segments.gen: [" + this.metadata.containsKey("segments.gen") + "]";
            return recoveryDiff;
        }

        public int size() {
            return this.metadata.size();
        }

        public static MetadataSnapshot read(StreamInput in) throws IOException {
            MetadataSnapshot storeFileMetaDatas = new MetadataSnapshot();
            storeFileMetaDatas.readFrom(in);
            return storeFileMetaDatas;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int size = in.readVInt();
            ImmutableMap.Builder<String, StoreFileMetaData> builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                StoreFileMetaData meta = StoreFileMetaData.readStoreFileMetaData(in);
                builder.put(meta.name(), meta);
            }
            this.metadata = builder.build();
            assert (this.metadata.isEmpty() || this.numSegmentFiles() == 1) : "numSegmentFiles: " + this.numSegmentFiles();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.metadata.size());
            for (StoreFileMetaData meta : this) {
                meta.writeTo(out);
            }
        }

        public boolean contains(String existingFile) {
            return this.metadata.containsKey(existingFile);
        }

        public StoreFileMetaData getSegmentsFile() {
            for (StoreFileMetaData file : this) {
                if (!file.name().startsWith("segments")) continue;
                return file;
            }
            assert (this.metadata.isEmpty());
            return null;
        }

        private final int numSegmentFiles() {
            int count = 0;
            for (StoreFileMetaData file : this) {
                if (!file.name().startsWith("segments")) continue;
                ++count;
            }
            return count;
        }
    }

    public final class StoreDirectory
    extends FilterDirectory {
        public final ESLogger deletesLogger;

        StoreDirectory(Directory delegateDirectory) throws IOException {
            super(delegateDirectory);
            this.deletesLogger = Loggers.getLogger("index.store.deletes", Store.this.indexSettings, Store.this.shardId, new String[0]);
        }

        public ShardId shardId() {
            this.ensureOpen();
            return Store.this.shardId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IndexInput openInput(String name, IOContext context) throws IOException {
            IndexInput in = super.openInput(name, context);
            boolean success = false;
            try {
                Compressor compressor;
                if ((name.endsWith(".fdt") || name.endsWith(".tvf")) && (compressor = CompressorFactory.compressor(in)) != null) {
                    return compressor.indexInput(in);
                }
                success = true;
                if (success) return in;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
            return in;
        }

        public void close() throws IOException {
            assert (false) : "Nobody should close this directory except of the Store itself";
        }

        public void deleteFile(String name) throws IOException {
            Store.this.logDeleteFile("StoreDirectory.deleteFile", name);
            super.deleteFile(name);
        }

        private void innerClose() throws IOException {
            super.close();
        }

        public String toString() {
            return "store(" + this.in.toString() + ")";
        }
    }
}

