/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.hppc.DoubleOpenHashSet;
import org.elasticsearch.common.hppc.LongOpenHashSet;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.lucene.docset.MatchDocIdSet;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

public abstract class FieldDataTermsFilter
extends Filter {
    final IndexFieldData fieldData;

    protected FieldDataTermsFilter(IndexFieldData fieldData) {
        this.fieldData = fieldData;
    }

    public static FieldDataTermsFilter newBytes(IndexFieldData fieldData, ObjectOpenHashSet<BytesRef> terms) {
        return new BytesFieldDataFilter(fieldData, terms);
    }

    public static FieldDataTermsFilter newLongs(IndexNumericFieldData fieldData, LongOpenHashSet terms) {
        return new LongsFieldDataFilter(fieldData, terms);
    }

    public static FieldDataTermsFilter newDoubles(IndexNumericFieldData fieldData, DoubleOpenHashSet terms) {
        return new DoublesFieldDataFilter(fieldData, terms);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FieldDataTermsFilter that = (FieldDataTermsFilter)((Object)obj);
        return this.fieldData.getFieldNames().indexName().equals(that.fieldData.getFieldNames().indexName());
    }

    public int hashCode() {
        return 31 * ((Object)((Object)this)).getClass().hashCode() + this.fieldData.getFieldNames().indexName().hashCode();
    }

    public abstract String toString();

    protected static class DoublesFieldDataFilter
    extends FieldDataTermsFilter {
        final DoubleOpenHashSet terms;

        protected DoublesFieldDataFilter(IndexNumericFieldData fieldData, DoubleOpenHashSet terms) {
            super(fieldData);
            this.terms = terms;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            return this.terms.equals(((BytesFieldDataFilter)((Object)obj)).terms);
        }

        @Override
        public int hashCode() {
            int hashcode = super.hashCode();
            hashcode = 31 * hashcode + (this.terms != null ? this.terms.hashCode() : 0);
            return hashcode;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("DoublesFieldDataFilter");
            return sb.append(this.fieldData.getFieldNames().indexName()).append(":").append(this.terms != null ? this.terms.toString() : "").toString();
        }

        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            if (this.terms == null || this.terms.isEmpty()) {
                return null;
            }
            IndexNumericFieldData indexNumericFieldData = (IndexNumericFieldData)this.fieldData;
            if (indexNumericFieldData.getNumericType().isFloatingPoint()) {
                final SortedNumericDoubleValues values = ((AtomicNumericFieldData)indexNumericFieldData.load(context)).getDoubleValues();
                return new MatchDocIdSet(context.reader().maxDoc(), acceptDocs){

                    @Override
                    protected boolean matchDoc(int doc) {
                        values.setDocument(doc);
                        int numVals = values.count();
                        for (int i = 0; i < numVals; ++i) {
                            if (!DoublesFieldDataFilter.this.terms.contains(values.valueAt(i))) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            return null;
        }
    }

    protected static class LongsFieldDataFilter
    extends FieldDataTermsFilter {
        final LongOpenHashSet terms;

        protected LongsFieldDataFilter(IndexNumericFieldData fieldData, LongOpenHashSet terms) {
            super(fieldData);
            this.terms = terms;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            return this.terms.equals(((BytesFieldDataFilter)((Object)obj)).terms);
        }

        @Override
        public int hashCode() {
            int hashcode = super.hashCode();
            hashcode = 31 * hashcode + (this.terms != null ? this.terms.hashCode() : 0);
            return hashcode;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("LongsFieldDataFilter:");
            return sb.append(this.fieldData.getFieldNames().indexName()).append(":").append(this.terms != null ? this.terms.toString() : "").toString();
        }

        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            if (this.terms == null || this.terms.isEmpty()) {
                return null;
            }
            IndexNumericFieldData numericFieldData = (IndexNumericFieldData)this.fieldData;
            if (!numericFieldData.getNumericType().isFloatingPoint()) {
                final SortedNumericDocValues values = ((AtomicNumericFieldData)numericFieldData.load(context)).getLongValues();
                return new MatchDocIdSet(context.reader().maxDoc(), acceptDocs){

                    @Override
                    protected boolean matchDoc(int doc) {
                        values.setDocument(doc);
                        int numVals = values.count();
                        for (int i = 0; i < numVals; ++i) {
                            if (!LongsFieldDataFilter.this.terms.contains(values.valueAt(i))) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            return null;
        }
    }

    protected static class BytesFieldDataFilter
    extends FieldDataTermsFilter {
        final ObjectOpenHashSet<BytesRef> terms;

        protected BytesFieldDataFilter(IndexFieldData fieldData, ObjectOpenHashSet<BytesRef> terms) {
            super(fieldData);
            this.terms = terms;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            return this.terms.equals(((BytesFieldDataFilter)((Object)obj)).terms);
        }

        @Override
        public int hashCode() {
            int hashcode = super.hashCode();
            hashcode = 31 * hashcode + (this.terms != null ? this.terms.hashCode() : 0);
            return hashcode;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("BytesFieldDataFilter:");
            return sb.append(this.fieldData.getFieldNames().indexName()).append(":").append(this.terms != null ? this.terms.toString() : "").toString();
        }

        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            if (this.terms == null || this.terms.isEmpty()) {
                return null;
            }
            final SortedBinaryDocValues values = this.fieldData.load(context).getBytesValues();
            return new MatchDocIdSet(context.reader().maxDoc(), acceptDocs){

                @Override
                protected boolean matchDoc(int doc) {
                    values.setDocument(doc);
                    int numVals = values.count();
                    for (int i = 0; i < numVals; ++i) {
                        if (!BytesFieldDataFilter.this.terms.contains(values.valueAt(i))) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

