/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ObjectMapperListener;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.search.highlight.HighlighterContext;

public class AnalyzerMapper
implements Mapper,
InternalMapper,
RootMapper {
    public static final String NAME = "_analyzer";
    public static final String CONTENT_TYPE = "_analyzer";
    private final String path;

    public AnalyzerMapper() {
        this("_analyzer");
    }

    public AnalyzerMapper(String path) {
        this.path = path.intern();
    }

    @Override
    public String name() {
        return "_analyzer";
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        Object analyzer = context.docMapper().mappers().indexAnalyzer();
        if (this.path != null) {
            String value = null;
            List<IndexableField> fields = context.doc().getFields();
            int fieldsSize = fields.size();
            for (int i = 0; i < fieldsSize; ++i) {
                IndexableField field = fields.get(i);
                if (!field.name().equals(this.path)) continue;
                value = field.stringValue();
                break;
            }
            if (value == null) {
                value = context.ignoredValue(this.path);
            }
            if (value != null) {
                analyzer = context.analysisService().analyzer(value);
                if (analyzer == null) {
                    throw new MapperParsingException("No analyzer found for [" + value + "] from path [" + this.path + "]");
                }
                analyzer = context.docMapper().mappers().indexAnalyzer((Analyzer)analyzer);
            }
        }
        context.analyzer((Analyzer)analyzer);
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    public Analyzer setAnalyzer(HighlighterContext context) {
        if (context.analyzer() != null) {
            return context.analyzer();
        }
        Object analyzer = null;
        if (this.path != null) {
            String analyzerName = (String)context.context.lookup().source().extractValue(this.path);
            analyzer = context.context.mapperService().analysisService().analyzer(analyzerName);
        }
        if (analyzer == null) {
            analyzer = context.context.mapperService().documentMapper(context.hitContext.hit().type()).mappers().indexAnalyzer();
        }
        context.analyzer((Analyzer)analyzer);
        return analyzer;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    @Override
    public void traverse(FieldMapperListener fieldMapperListener) {
    }

    @Override
    public void traverse(ObjectMapperListener objectMapperListener) {
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.path.equals("_analyzer")) {
            return builder;
        }
        builder.startObject("_analyzer");
        if (!this.path.equals("_analyzer")) {
            builder.field("path", this.path);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void close() {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.analyzer();
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("path")) continue;
                builder.field(fieldNode.toString());
            }
            return builder;
        }
    }

    public static class Builder
    extends Mapper.Builder<Builder, AnalyzerMapper> {
        private String field = "_analyzer";

        public Builder() {
            super("_analyzer");
            this.builder = this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public AnalyzerMapper build(Mapper.BuilderContext context) {
            return new AnalyzerMapper(this.field);
        }
    }

    public static class Defaults {
        public static final String PATH = "_analyzer";
    }
}

