/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;

public class CustomFieldsVisitor
extends FieldsVisitor {
    private final boolean loadSource;
    private final Set<String> fields;

    public CustomFieldsVisitor(Set<String> fields, boolean loadSource) {
        this.loadSource = loadSource;
        this.fields = fields;
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if (this.loadSource && "_source".equals(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        if ("_uid".equals(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        return this.fields.contains(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
    }
}

