/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.netty.buffer.BigEndianHeapChannelBuffer;
import org.elasticsearch.common.netty.buffer.ByteBufferBackedChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBufferFactory;
import org.elasticsearch.common.netty.buffer.ChannelBufferIndexFinder;
import org.elasticsearch.common.netty.buffer.CompositeChannelBuffer;
import org.elasticsearch.common.netty.buffer.DynamicChannelBuffer;
import org.elasticsearch.common.netty.buffer.EmptyChannelBuffer;
import org.elasticsearch.common.netty.buffer.LittleEndianHeapChannelBuffer;
import org.elasticsearch.common.netty.buffer.ReadOnlyChannelBuffer;
import org.elasticsearch.common.netty.buffer.SlicedChannelBuffer;
import org.elasticsearch.common.netty.buffer.TruncatedChannelBuffer;
import org.elasticsearch.common.netty.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelBuffers {
    public static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    public static final ChannelBuffer EMPTY_BUFFER = new EmptyChannelBuffer();
    private static final char[] HEXDUMP_TABLE = new char[1024];

    public static ChannelBuffer buffer(int capacity) {
        return ChannelBuffers.buffer(BIG_ENDIAN, capacity);
    }

    public static ChannelBuffer buffer(ByteOrder endianness, int capacity) {
        if (endianness == BIG_ENDIAN) {
            if (capacity == 0) {
                return EMPTY_BUFFER;
            }
            return new BigEndianHeapChannelBuffer(capacity);
        }
        if (endianness == LITTLE_ENDIAN) {
            if (capacity == 0) {
                return EMPTY_BUFFER;
            }
            return new LittleEndianHeapChannelBuffer(capacity);
        }
        throw new NullPointerException("endianness");
    }

    public static ChannelBuffer directBuffer(int capacity) {
        return ChannelBuffers.directBuffer(BIG_ENDIAN, capacity);
    }

    public static ChannelBuffer directBuffer(ByteOrder endianness, int capacity) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (capacity == 0) {
            return EMPTY_BUFFER;
        }
        ByteBufferBackedChannelBuffer buffer = new ByteBufferBackedChannelBuffer(ByteBuffer.allocateDirect(capacity).order(endianness));
        buffer.clear();
        return buffer;
    }

    public static ChannelBuffer dynamicBuffer() {
        return ChannelBuffers.dynamicBuffer(BIG_ENDIAN, 256);
    }

    public static ChannelBuffer dynamicBuffer(ChannelBufferFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        return new DynamicChannelBuffer(factory.getDefaultOrder(), 256, factory);
    }

    public static ChannelBuffer dynamicBuffer(int estimatedLength) {
        return ChannelBuffers.dynamicBuffer(BIG_ENDIAN, estimatedLength);
    }

    public static ChannelBuffer dynamicBuffer(ByteOrder endianness, int estimatedLength) {
        return new DynamicChannelBuffer(endianness, estimatedLength);
    }

    public static ChannelBuffer dynamicBuffer(int estimatedLength, ChannelBufferFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        return new DynamicChannelBuffer(factory.getDefaultOrder(), estimatedLength, factory);
    }

    public static ChannelBuffer dynamicBuffer(ByteOrder endianness, int estimatedLength, ChannelBufferFactory factory) {
        return new DynamicChannelBuffer(endianness, estimatedLength, factory);
    }

    public static ChannelBuffer wrappedBuffer(byte[] array) {
        return ChannelBuffers.wrappedBuffer(BIG_ENDIAN, array);
    }

    public static ChannelBuffer wrappedBuffer(ByteOrder endianness, byte[] array) {
        if (endianness == BIG_ENDIAN) {
            if (array.length == 0) {
                return EMPTY_BUFFER;
            }
            return new BigEndianHeapChannelBuffer(array);
        }
        if (endianness == LITTLE_ENDIAN) {
            if (array.length == 0) {
                return EMPTY_BUFFER;
            }
            return new LittleEndianHeapChannelBuffer(array);
        }
        throw new NullPointerException("endianness");
    }

    public static ChannelBuffer wrappedBuffer(byte[] array, int offset, int length) {
        return ChannelBuffers.wrappedBuffer(BIG_ENDIAN, array, offset, length);
    }

    public static ChannelBuffer wrappedBuffer(ByteOrder endianness, byte[] array, int offset, int length) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (offset == 0) {
            if (length == array.length) {
                return ChannelBuffers.wrappedBuffer(endianness, array);
            }
            if (length == 0) {
                return EMPTY_BUFFER;
            }
            return new TruncatedChannelBuffer(ChannelBuffers.wrappedBuffer(endianness, array), length);
        }
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        return new SlicedChannelBuffer(ChannelBuffers.wrappedBuffer(endianness, array), offset, length);
    }

    public static ChannelBuffer wrappedBuffer(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return EMPTY_BUFFER;
        }
        if (buffer.hasArray()) {
            return ChannelBuffers.wrappedBuffer(buffer.order(), buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }
        return new ByteBufferBackedChannelBuffer(buffer);
    }

    public static ChannelBuffer wrappedBuffer(ChannelBuffer buffer) {
        if (buffer.readable()) {
            return buffer.slice();
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer wrappedBuffer(byte[] ... arrays) {
        return ChannelBuffers.wrappedBuffer(BIG_ENDIAN, arrays);
    }

    public static ChannelBuffer wrappedBuffer(ByteOrder endianness, byte[] ... arrays) {
        switch (arrays.length) {
            case 0: {
                break;
            }
            case 1: {
                if (arrays[0].length == 0) break;
                return ChannelBuffers.wrappedBuffer(endianness, arrays[0]);
            }
            default: {
                ArrayList<ChannelBuffer> components = new ArrayList<ChannelBuffer>(arrays.length);
                for (byte[] a : arrays) {
                    if (a == null) break;
                    if (a.length <= 0) continue;
                    components.add(ChannelBuffers.wrappedBuffer(endianness, a));
                }
                return ChannelBuffers.compositeBuffer(endianness, components, false);
            }
        }
        return EMPTY_BUFFER;
    }

    private static ChannelBuffer compositeBuffer(ByteOrder endianness, List<ChannelBuffer> components, boolean gathering) {
        switch (components.size()) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return components.get(0);
            }
        }
        return new CompositeChannelBuffer(endianness, components, gathering);
    }

    public static ChannelBuffer wrappedBuffer(ChannelBuffer ... buffers) {
        return ChannelBuffers.wrappedBuffer(false, buffers);
    }

    public static ChannelBuffer wrappedBuffer(boolean gathering, ChannelBuffer ... buffers) {
        switch (buffers.length) {
            case 0: {
                break;
            }
            case 1: {
                if (!buffers[0].readable()) break;
                return ChannelBuffers.wrappedBuffer(buffers[0]);
            }
            default: {
                ByteOrder order = null;
                ArrayList<ChannelBuffer> components = new ArrayList<ChannelBuffer>(buffers.length);
                for (ChannelBuffer c : buffers) {
                    if (c == null) break;
                    if (!c.readable()) continue;
                    if (order != null) {
                        if (!order.equals(c.order())) {
                            throw new IllegalArgumentException("inconsistent byte order");
                        }
                    } else {
                        order = c.order();
                    }
                    if (c instanceof CompositeChannelBuffer) {
                        components.addAll(((CompositeChannelBuffer)c).decompose(c.readerIndex(), c.readableBytes()));
                        continue;
                    }
                    components.add(c.slice());
                }
                return ChannelBuffers.compositeBuffer(order, components, gathering);
            }
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer wrappedBuffer(ByteBuffer ... buffers) {
        return ChannelBuffers.wrappedBuffer(false, buffers);
    }

    public static ChannelBuffer wrappedBuffer(boolean gathering, ByteBuffer ... buffers) {
        switch (buffers.length) {
            case 0: {
                break;
            }
            case 1: {
                if (!buffers[0].hasRemaining()) break;
                return ChannelBuffers.wrappedBuffer(buffers[0]);
            }
            default: {
                ByteOrder order = null;
                ArrayList<ChannelBuffer> components = new ArrayList<ChannelBuffer>(buffers.length);
                for (ByteBuffer b : buffers) {
                    if (b == null) break;
                    if (!b.hasRemaining()) continue;
                    if (order != null) {
                        if (!order.equals(b.order())) {
                            throw new IllegalArgumentException("inconsistent byte order");
                        }
                    } else {
                        order = b.order();
                    }
                    components.add(ChannelBuffers.wrappedBuffer(b));
                }
                return ChannelBuffers.compositeBuffer(order, components, gathering);
            }
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer copiedBuffer(byte[] array) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, array);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, byte[] array) {
        if (endianness == BIG_ENDIAN) {
            if (array.length == 0) {
                return EMPTY_BUFFER;
            }
            return new BigEndianHeapChannelBuffer((byte[])array.clone());
        }
        if (endianness == LITTLE_ENDIAN) {
            if (array.length == 0) {
                return EMPTY_BUFFER;
            }
            return new LittleEndianHeapChannelBuffer((byte[])array.clone());
        }
        throw new NullPointerException("endianness");
    }

    public static ChannelBuffer copiedBuffer(byte[] array, int offset, int length) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, array, offset, length);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, byte[] array, int offset, int length) {
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        byte[] copy = new byte[length];
        System.arraycopy(array, offset, copy, 0, length);
        return ChannelBuffers.wrappedBuffer(endianness, copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelBuffer copiedBuffer(ByteBuffer buffer) {
        int length = buffer.remaining();
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        byte[] copy = new byte[length];
        int position = buffer.position();
        try {
            buffer.get(copy);
            Object var5_4 = null;
            buffer.position(position);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            buffer.position(position);
            throw throwable;
        }
        return ChannelBuffers.wrappedBuffer(buffer.order(), copy);
    }

    public static ChannelBuffer copiedBuffer(ChannelBuffer buffer) {
        if (buffer.readable()) {
            return buffer.copy();
        }
        return EMPTY_BUFFER;
    }

    public static ChannelBuffer copiedBuffer(byte[] ... arrays) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, arrays);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, byte[] ... arrays) {
        switch (arrays.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                if (arrays[0].length == 0) {
                    return EMPTY_BUFFER;
                }
                return ChannelBuffers.copiedBuffer(endianness, arrays[0]);
            }
        }
        int length = 0;
        for (byte[] a : arrays) {
            if (Integer.MAX_VALUE - length < a.length) {
                throw new IllegalArgumentException("The total length of the specified arrays is too big.");
            }
            length += a.length;
        }
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        byte[] mergedArray = new byte[length];
        int j = 0;
        for (int i = 0; i < arrays.length; ++i) {
            byte[] a;
            a = arrays[i];
            System.arraycopy(a, 0, mergedArray, j, a.length);
            j += a.length;
        }
        return ChannelBuffers.wrappedBuffer(endianness, mergedArray);
    }

    public static ChannelBuffer copiedBuffer(ChannelBuffer ... buffers) {
        switch (buffers.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return ChannelBuffers.copiedBuffer(buffers[0]);
            }
        }
        ChannelBuffer[] copiedBuffers = new ChannelBuffer[buffers.length];
        for (int i = 0; i < buffers.length; ++i) {
            copiedBuffers[i] = ChannelBuffers.copiedBuffer(buffers[i]);
        }
        return ChannelBuffers.wrappedBuffer(false, copiedBuffers);
    }

    public static ChannelBuffer copiedBuffer(ByteBuffer ... buffers) {
        switch (buffers.length) {
            case 0: {
                return EMPTY_BUFFER;
            }
            case 1: {
                return ChannelBuffers.copiedBuffer(buffers[0]);
            }
        }
        ChannelBuffer[] copiedBuffers = new ChannelBuffer[buffers.length];
        for (int i = 0; i < buffers.length; ++i) {
            copiedBuffers[i] = ChannelBuffers.copiedBuffer(buffers[i]);
        }
        return ChannelBuffers.wrappedBuffer(false, copiedBuffers);
    }

    public static ChannelBuffer copiedBuffer(CharSequence string, Charset charset) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, string, charset);
    }

    public static ChannelBuffer copiedBuffer(CharSequence string, int offset, int length, Charset charset) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, string, offset, length, charset);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, CharSequence string, Charset charset) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        if (string instanceof CharBuffer) {
            return ChannelBuffers.copiedBuffer(endianness, (CharBuffer)string, charset);
        }
        return ChannelBuffers.copiedBuffer(endianness, CharBuffer.wrap(string), charset);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, CharSequence string, int offset, int length, Charset charset) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        if (string instanceof CharBuffer) {
            CharBuffer buf = (CharBuffer)string;
            if (buf.hasArray()) {
                return ChannelBuffers.copiedBuffer(endianness, buf.array(), buf.arrayOffset() + buf.position() + offset, length, charset);
            }
            buf = buf.slice();
            buf.limit(length);
            buf.position(offset);
            return ChannelBuffers.copiedBuffer(endianness, buf, charset);
        }
        return ChannelBuffers.copiedBuffer(endianness, CharBuffer.wrap(string, offset, offset + length), charset);
    }

    public static ChannelBuffer copiedBuffer(char[] array, Charset charset) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, array, 0, array.length, charset);
    }

    public static ChannelBuffer copiedBuffer(char[] array, int offset, int length, Charset charset) {
        return ChannelBuffers.copiedBuffer(BIG_ENDIAN, array, offset, length, charset);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, char[] array, Charset charset) {
        return ChannelBuffers.copiedBuffer(endianness, array, 0, array.length, charset);
    }

    public static ChannelBuffer copiedBuffer(ByteOrder endianness, char[] array, int offset, int length, Charset charset) {
        if (array == null) {
            throw new NullPointerException("array");
        }
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        return ChannelBuffers.copiedBuffer(endianness, CharBuffer.wrap(array, offset, length), charset);
    }

    private static ChannelBuffer copiedBuffer(ByteOrder endianness, CharBuffer buffer, Charset charset) {
        CharBuffer src = buffer;
        ByteBuffer dst = ChannelBuffers.encodeString(src, charset);
        ChannelBuffer result = ChannelBuffers.wrappedBuffer(endianness, dst.array());
        result.writerIndex(dst.remaining());
        return result;
    }

    public static ChannelBuffer unmodifiableBuffer(ChannelBuffer buffer) {
        if (buffer instanceof ReadOnlyChannelBuffer) {
            buffer = ((ReadOnlyChannelBuffer)buffer).unwrap();
        }
        return new ReadOnlyChannelBuffer(buffer);
    }

    public static ChannelBuffer hexDump(String hexString) {
        int len = hexString.length();
        byte[] hexData = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            hexData[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return ChannelBuffers.wrappedBuffer(hexData);
    }

    public static String hexDump(ChannelBuffer buffer) {
        return ChannelBuffers.hexDump(buffer, buffer.readerIndex(), buffer.readableBytes());
    }

    public static String hexDump(ChannelBuffer buffer, int fromIndex, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length: " + length);
        }
        if (length == 0) {
            return "";
        }
        int endIndex = fromIndex + length;
        char[] buf = new char[length << 1];
        int srcIdx = fromIndex;
        int dstIdx = 0;
        while (srcIdx < endIndex) {
            System.arraycopy(HEXDUMP_TABLE, buffer.getUnsignedByte(srcIdx) << 1, buf, dstIdx, 2);
            ++srcIdx;
            dstIdx += 2;
        }
        return new String(buf);
    }

    public static int hashCode(ChannelBuffer buffer) {
        int i;
        int aLen = buffer.readableBytes();
        int intCount = aLen >>> 2;
        int byteCount = aLen & 3;
        int hashCode = 1;
        int arrayIndex = buffer.readerIndex();
        if (buffer.order() == BIG_ENDIAN) {
            for (i = intCount; i > 0; --i) {
                hashCode = 31 * hashCode + buffer.getInt(arrayIndex);
                arrayIndex += 4;
            }
        } else {
            for (i = intCount; i > 0; --i) {
                hashCode = 31 * hashCode + ChannelBuffers.swapInt(buffer.getInt(arrayIndex));
                arrayIndex += 4;
            }
        }
        for (i = byteCount; i > 0; --i) {
            hashCode = 31 * hashCode + buffer.getByte(arrayIndex++);
        }
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    public static boolean equals(ChannelBuffer bufferA, ChannelBuffer bufferB) {
        int i;
        int aLen = bufferA.readableBytes();
        if (aLen != bufferB.readableBytes()) {
            return false;
        }
        int longCount = aLen >>> 3;
        int byteCount = aLen & 7;
        int aIndex = bufferA.readerIndex();
        int bIndex = bufferB.readerIndex();
        if (bufferA.order() == bufferB.order()) {
            for (i = longCount; i > 0; --i) {
                if (bufferA.getLong(aIndex) != bufferB.getLong(bIndex)) {
                    return false;
                }
                aIndex += 8;
                bIndex += 8;
            }
        } else {
            for (i = longCount; i > 0; --i) {
                if (bufferA.getLong(aIndex) != ChannelBuffers.swapLong(bufferB.getLong(bIndex))) {
                    return false;
                }
                aIndex += 8;
                bIndex += 8;
            }
        }
        for (i = byteCount; i > 0; --i) {
            if (bufferA.getByte(aIndex) != bufferB.getByte(bIndex)) {
                return false;
            }
            ++aIndex;
            ++bIndex;
        }
        return true;
    }

    public static int compare(ChannelBuffer bufferA, ChannelBuffer bufferB) {
        long vb;
        long va;
        int i;
        int aLen = bufferA.readableBytes();
        int bLen = bufferB.readableBytes();
        int minLength = Math.min(aLen, bLen);
        int uintCount = minLength >>> 2;
        int byteCount = minLength & 3;
        int aIndex = bufferA.readerIndex();
        int bIndex = bufferB.readerIndex();
        if (bufferA.order() == bufferB.order()) {
            for (i = uintCount; i > 0; --i) {
                va = bufferA.getUnsignedInt(aIndex);
                if (va > (vb = bufferB.getUnsignedInt(bIndex))) {
                    return 1;
                }
                if (va < vb) {
                    return -1;
                }
                aIndex += 4;
                bIndex += 4;
            }
        } else {
            for (i = uintCount; i > 0; --i) {
                va = bufferA.getUnsignedInt(aIndex);
                if (va > (vb = (long)ChannelBuffers.swapInt(bufferB.getInt(bIndex)) & 0xFFFFFFFFL)) {
                    return 1;
                }
                if (va < vb) {
                    return -1;
                }
                aIndex += 4;
                bIndex += 4;
            }
        }
        for (i = byteCount; i > 0; --i) {
            short vb2;
            short va2 = bufferA.getUnsignedByte(aIndex);
            if (va2 > (vb2 = bufferB.getUnsignedByte(bIndex))) {
                return 1;
            }
            if (va2 < vb2) {
                return -1;
            }
            ++aIndex;
            ++bIndex;
        }
        return aLen - bLen;
    }

    public static int indexOf(ChannelBuffer buffer, int fromIndex, int toIndex, byte value) {
        if (fromIndex <= toIndex) {
            return ChannelBuffers.firstIndexOf(buffer, fromIndex, toIndex, value);
        }
        return ChannelBuffers.lastIndexOf(buffer, fromIndex, toIndex, value);
    }

    public static int indexOf(ChannelBuffer buffer, int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        if (fromIndex <= toIndex) {
            return ChannelBuffers.firstIndexOf(buffer, fromIndex, toIndex, indexFinder);
        }
        return ChannelBuffers.lastIndexOf(buffer, fromIndex, toIndex, indexFinder);
    }

    public static short swapShort(short value) {
        return (short)(value << 8 | value >>> 8 & 0xFF);
    }

    public static int swapMedium(int value) {
        return value << 16 & 0xFF0000 | value & 0xFF00 | value >>> 16 & 0xFF;
    }

    public static int swapInt(int value) {
        return ChannelBuffers.swapShort((short)value) << 16 | ChannelBuffers.swapShort((short)(value >>> 16)) & 0xFFFF;
    }

    public static long swapLong(long value) {
        return (long)ChannelBuffers.swapInt((int)value) << 32 | (long)ChannelBuffers.swapInt((int)(value >>> 32)) & 0xFFFFFFFFL;
    }

    private static int firstIndexOf(ChannelBuffer buffer, int fromIndex, int toIndex, byte value) {
        if ((fromIndex = Math.max(fromIndex, 0)) >= toIndex || buffer.capacity() == 0) {
            return -1;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (buffer.getByte(i) != value) continue;
            return i;
        }
        return -1;
    }

    private static int lastIndexOf(ChannelBuffer buffer, int fromIndex, int toIndex, byte value) {
        if ((fromIndex = Math.min(fromIndex, buffer.capacity())) < 0 || buffer.capacity() == 0) {
            return -1;
        }
        for (int i = fromIndex - 1; i >= toIndex; --i) {
            if (buffer.getByte(i) != value) continue;
            return i;
        }
        return -1;
    }

    private static int firstIndexOf(ChannelBuffer buffer, int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        if ((fromIndex = Math.max(fromIndex, 0)) >= toIndex || buffer.capacity() == 0) {
            return -1;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!indexFinder.find(buffer, i)) continue;
            return i;
        }
        return -1;
    }

    private static int lastIndexOf(ChannelBuffer buffer, int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        if ((fromIndex = Math.min(fromIndex, buffer.capacity())) < 0 || buffer.capacity() == 0) {
            return -1;
        }
        for (int i = fromIndex - 1; i >= toIndex; --i) {
            if (!indexFinder.find(buffer, i)) continue;
            return i;
        }
        return -1;
    }

    static ByteBuffer encodeString(CharBuffer src, Charset charset) {
        CharsetEncoder encoder = CharsetUtil.getEncoder(charset);
        ByteBuffer dst = ByteBuffer.allocate((int)((double)src.remaining() * (double)encoder.maxBytesPerChar()));
        try {
            CoderResult cr = encoder.encode(src, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = encoder.flush(dst)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
        dst.flip();
        return dst;
    }

    static String decodeString(ByteBuffer src, Charset charset) {
        CharsetDecoder decoder = CharsetUtil.getDecoder(charset);
        CharBuffer dst = CharBuffer.allocate((int)((double)src.remaining() * (double)decoder.maxCharsPerByte()));
        try {
            CoderResult cr = decoder.decode(src, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = decoder.flush(dst)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
        return dst.flip().toString();
    }

    private ChannelBuffers() {
    }

    static {
        char[] DIGITS = "0123456789abcdef".toCharArray();
        for (int i = 0; i < 256; ++i) {
            ChannelBuffers.HEXDUMP_TABLE[i << 1] = DIGITS[i >>> 4 & 0xF];
            ChannelBuffers.HEXDUMP_TABLE[(i << 1) + 1] = DIGITS[i & 0xF];
        }
    }
}

