/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport.support;

import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.TransportActionNodeProxy;
import org.elasticsearch.action.admin.indices.IndicesAction;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.support.AbstractIndicesAdminClient;
import org.elasticsearch.client.support.Headers;
import org.elasticsearch.client.transport.TransportClientNodesService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class InternalTransportIndicesAdminClient
extends AbstractIndicesAdminClient
implements IndicesAdminClient {
    private final TransportClientNodesService nodesService;
    private final ThreadPool threadPool;
    private final ImmutableMap<Action, TransportActionNodeProxy> actions;
    private final Headers headers;

    @Inject
    public InternalTransportIndicesAdminClient(Settings settings, TransportClientNodesService nodesService, TransportService transportService, ThreadPool threadPool, Map<String, GenericAction> actions, Headers headers) {
        this.nodesService = nodesService;
        this.threadPool = threadPool;
        this.headers = headers;
        MapBuilder actionsBuilder = new MapBuilder();
        for (GenericAction action : actions.values()) {
            if (!(action instanceof IndicesAction)) continue;
            actionsBuilder.put((Action)action, new TransportActionNodeProxy(settings, action, transportService));
        }
        this.actions = actionsBuilder.immutableMap();
    }

    @Override
    public ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, IndicesAdminClient>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder, IndicesAdminClient> action, Request request) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.execute(action, request, (ActionListener<Response>)actionFuture);
        return actionFuture;
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, IndicesAdminClient>> void execute(Action<Request, Response, RequestBuilder, IndicesAdminClient> action, final Request request, ActionListener<Response> listener) {
        this.headers.applyTo(request);
        final TransportActionNodeProxy proxy = this.actions.get(action);
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<Response>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<Response> listener) {
                proxy.execute(node, request, listener);
            }
        }, listener);
    }
}

