/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class BulkShardResponse
extends ActionResponse {
    private ShardId shardId;
    private BulkItemResponse[] responses;

    BulkShardResponse() {
    }

    BulkShardResponse(ShardId shardId, BulkItemResponse[] responses) {
        this.shardId = shardId;
        this.responses = responses;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public BulkItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardId = ShardId.readShardId(in);
        this.responses = new BulkItemResponse[in.readVInt()];
        for (int i = 0; i < this.responses.length; ++i) {
            this.responses[i] = BulkItemResponse.readBulkItem(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        out.writeVInt(this.responses.length);
        for (BulkItemResponse response : this.responses) {
            response.writeTo(out);
        }
    }
}

