/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.container.services;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.etcd.EtcdService;
import org.nuxeo.io.container.services.PusherService;
import org.nuxeo.runtime.api.Framework;

public class PusherServiceImpl
implements PusherService {
    private static final Log log = LogFactory.getLog(PusherServiceImpl.class);
    public static final String SERVICE_KEY_PATTERN = "/services/%s";
    public static final String SERVICE_STATUS_KEY_PATTERN = "/services/%s/%d/status";
    public static final String SERVICE_CURRENT_STATUS_KEY_PATTERN = "/services/%s/%d/status/current";
    public static final String SERVICE_CONFIG_KEY_PATTERN = "/services/%s/%d/config";
    public static final String SERVICE_CONFIG_PACKAGES = "/services/%s/%d/config/packages";
    public static final String SERVICE_ALIVE_STATUS_KEY_PATTERN = "/services/%s/%d/status/alive";
    protected static int _1 = 1;

    @Override
    public void pushPackages() {
        EtcdService etcdService = (EtcdService)Framework.getLocalService(EtcdService.class);
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        String key = String.format(SERVICE_CONFIG_PACKAGES, System.getenv("ENV_TECH_ID"), _1);
        List installedPackages = pm.listLocalPackages(PackageType.getByValue((String)"addon"));
        ArrayList<String> installedPkgIds = new ArrayList<String>();
        for (Object installPackage : installedPackages) {
            if (!pm.isInstalled((Package)installPackage)) continue;
            installedPkgIds.add(installPackage.getName());
        }
        List installedStudios = pm.listAllStudioRemoteOrLocalPackages();
        for (DownloadablePackage studioPackage : installedStudios) {
            if (!PackageState.getByValue((int)studioPackage.getState()).isInstalled()) continue;
            installedPkgIds.add(studioPackage.getId());
        }
        String packages = StringUtils.join(installedPkgIds, (String)" ");
        log.info((Object)("Update installed package list: " + packages));
        etcdService.set(key, packages);
    }

    @Override
    public void pushCurrentStatus() {
        EtcdService etcdService = (EtcdService)Framework.getLocalService(EtcdService.class);
        String key = String.format(SERVICE_CURRENT_STATUS_KEY_PATTERN, System.getenv("ENV_TECH_ID"), _1);
        etcdService.set(key, "started");
    }

    @Override
    public void pushAliveStatus() {
        EtcdService etcdService = (EtcdService)Framework.getLocalService(EtcdService.class);
        String key = String.format(SERVICE_ALIVE_STATUS_KEY_PATTERN, System.getenv("ENV_TECH_ID"), _1);
        etcdService.set(key, "1", 10);
    }
}

