/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.container.filter;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;
import org.nuxeo.runtime.api.Framework;

public class IoContainerWebFilter
implements Filter {
    private static final Log log = LogFactory.getLog(IoContainerWebFilter.class);
    protected Set<String> keys = new HashSet<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            this.putProperty("nuxeo_url", Framework.getProperty((String)"nuxeo.url"));
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.cleanUp();
        }
    }

    public void destroy() {
    }

    protected void putProperty(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (Object)value);
            this.keys.add(key);
        }
    }

    protected void cleanUp() {
        for (String key : this.keys) {
            MDC.remove((String)key);
        }
    }
}

