/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap.management;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import org.nuxeo.ecm.core.management.api.Probe;
import org.nuxeo.ecm.core.management.api.ProbeStatus;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class LDAPDirectoriesProbe
implements Probe {
    public ProbeStatus run() {
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        boolean success = true;
        HashMap<String, String> infos = new HashMap<String, String>();
        for (String id : directoryService.getDirectoryNames()) {
            BaseDirectoryDescriptor descriptor = directoryService.getDirectoryDescriptor(id);
            if (!(descriptor instanceof LDAPDirectoryDescriptor)) continue;
            Directory dir = directoryService.getDirectory(id);
            long startTime = Calendar.getInstance().getTimeInMillis();
            String dirName = null;
            try {
                Session dirSession = dir.getSession();
                dirSession.close();
                dirName = dir.getName();
            }
            catch (DirectoryException e) {
                success = false;
            }
            long endTime = Calendar.getInstance().getTimeInMillis();
            Properties props = ((LDAPDirectory)dir).getContextProperties();
            String bindDN = (String)props.get("java.naming.security.principal");
            infos.put(dirName + "-bind", bindDN);
            infos.put(dirName + "-time", new Long(endTime - startTime).toString());
        }
        if (infos.size() == 0) {
            infos.put("info", "No configured LDAP directory");
        }
        if (!success) {
            return ProbeStatus.newFailure(infos);
        }
        return ProbeStatus.newSuccess(infos);
    }
}

