/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.permissions;

import java.util.Collections;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.features.PlatformFunctions;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.permissions.PermissionHelper;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationService;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.api.Framework;

public class PermissionGrantedNotificationListener
implements PostCommitFilteringEventListener {
    public static final String LABEL_SUBJECT_NEW_PERMISSION = "label.subject.new.permission";
    private static final Log log = LogFactory.getLog(PermissionGrantedNotificationListener.class);
    public static final String SUBJECT_FORMAT = "%s %s";

    public void handleEvent(EventBundle events) {
        for (Event event : events) {
            this.handleEvent(event);
        }
    }

    protected void handleEvent(Event event) {
        EventContext eventCtx = event.getContext();
        if (!(eventCtx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)eventCtx;
        CoreSession coreSession = docCtx.getCoreSession();
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc == null || !coreSession.exists(doc.getRef())) {
            return;
        }
        ACE ace = (ACE)docCtx.getProperty("ace");
        String aclName = (String)((Object)docCtx.getProperty("aclName"));
        if (ace == null || ace.isDenied() || aclName == null) {
            return;
        }
        String username = ace.getUsername();
        StringList to = this.getRecipients(username);
        if (to == null) {
            return;
        }
        Expression from = Scripting.newExpression((String)"Env[\"mail.from\"]");
        NotificationService notificationService = NotificationServiceHelper.getNotificationService();
        String subject = String.format(SUBJECT_FORMAT, notificationService.getEMailSubjectPrefix(), I18NUtils.getMessageString((String)"messages", (String)LABEL_SUBJECT_NEW_PERMISSION, (Object[])new Object[]{doc.getTitle()}, (Locale)Locale.ENGLISH));
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = directoryService.open("aceinfo");){
            TokenAuthenticationService tokenAuthenticationService;
            String token;
            UserManager userManager;
            NuxeoPrincipal creator;
            String aceCreator;
            String comment;
            String id = PermissionHelper.computeDirectoryId(doc, aclName, ace.getId());
            DocumentModel entry = session.getEntry(id);
            OperationContext ctx = new OperationContext(coreSession);
            ctx.setInput((Object)doc);
            ctx.put("ace", (Object)ace);
            if (entry != null && (comment = (String)((Object)entry.getPropertyValue("aceinfo:comment"))) != null) {
                comment = StringEscapeUtils.escapeHtml((String)comment);
                comment = comment.replaceAll("\n", "<br/>");
                ctx.put("comment", (Object)comment);
            }
            if ((aceCreator = ace.getCreator()) != null && (creator = (userManager = (UserManager)Framework.getService(UserManager.class)).getPrincipal(aceCreator)) != null) {
                ctx.put("aceCreator", (Object)String.format("%s (%s)", Functions.principalFullName((NuxeoPrincipal)creator), creator.getName()));
            }
            if (NuxeoPrincipal.isTransientUsername((String)username) && (token = (tokenAuthenticationService = (TokenAuthenticationService)Framework.getService(TokenAuthenticationService.class)).getToken(username, doc.getRepositoryName(), doc.getId())) != null) {
                ctx.put("token", (Object)token);
            }
            OperationChain chain = new OperationChain("SendMail");
            chain.add("Document.Mail").set("from", (Object)from).set("to", (Object)to).set("HTML", (Object)true).set("subject", (Object)subject).set("message", (Object)"template:aceGranted");
            ((AutomationService)Framework.getService(AutomationService.class)).run(ctx, chain);
        }
        catch (OperationException e) {
            log.warn((Object)"Unable to notify user", (Throwable)e);
            log.debug((Object)e, (Throwable)e);
        }
    }

    protected StringList getRecipients(String username) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        NuxeoPrincipal principal = userManager.getPrincipal(username);
        StringList to = null;
        if (principal != null) {
            to = new StringList(Collections.singletonList(principal.getEmail()));
        } else {
            NuxeoGroup group = userManager.getGroup(username);
            if (group != null) {
                PlatformFunctions platformFunctions = new PlatformFunctions();
                to = platformFunctions.getEmailsFromGroup(group.getName());
            }
        }
        return to;
    }

    public boolean acceptEvent(Event event) {
        String eventName = event.getName();
        return "permissionNotification".equals(eventName);
    }
}

