/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.invite;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.user.invite.InvitationUserFactory;

@XObject(value="configuration")
public class UserRegistrationConfiguration {
    private static Log log = LogFactory.getLog(UserRegistrationConfiguration.class);
    public static final String DEFAULT_CONFIGURATION_NAME = "default_registration";
    @XNode(value="@merge")
    private boolean merge = false;
    @XNode(value="@remove")
    private boolean remove = false;
    @XNode(value="@name")
    private String name = "default_registration";
    @XNode(value="requestDocType")
    private String requestDocType;
    @XNode(value="userInfo/schemaName")
    private String userInfoSchemaName = "userinfo";
    @XNode(value="userInfo/usernameField")
    private String userInfoUsernameField = "userinfo:login";
    @XNode(value="userInfo/emailField")
    private String userInfoEmailField = "userinfo:email";
    @XNode(value="userInfo/firstnameField")
    private String userInfoFirstnameField = "userinfo:firstName";
    @XNode(value="userInfo/lastnameField")
    private String userInfoLastnameField = "userinfo:lastName";
    @XNode(value="userInfo/companyField")
    private String userInfoCompanyField = "userinfo:company";
    @Deprecated
    @XNode(value="userInfo/passwordField")
    private String userInfoPasswordField = "userinfo:password";
    @XNode(value="userInfo/groupsField")
    private String userInfoGroupsField = "userinfo:groups";
    @XNode(value="userInfo/tenantIdField")
    private String userInfoTenantIdField = "userinfo:tenantId";
    @XNode(value="container/docType")
    private String containerDocType;
    @XNode(value="container/parentPath")
    private String containerParentPath;
    @XNode(value="container/name")
    private String containerName;
    @XNode(value="container/title")
    private String containerTitle;
    @XNode(value="validationEmail/title")
    private String validationEmailTitle;
    @XNode(value="validationEmail/template")
    private String validationEmailTemplate;
    @XNode(value="successEmail/title")
    private String successEmailTitle;
    @XNode(value="successEmail/template")
    private String successEmailTemplate;
    @XNode(value="reviveEmail/title")
    private String reviveEmailTitle;
    @XNode(value="reviveEmail/template")
    private String reviveEmailTemplate;
    @XNode(value="registrationUserFactory")
    private Class<? extends InvitationUserFactory> registrationUserFactory;
    @XNode(value="validationRelUrl")
    private String validationRelUrl;
    @XNode(value="enterPasswordUrl")
    private String enterPasswordUrl;
    @XNode(value="invitationLayout")
    private String invitationLayout = "user_invitation_info";
    @XNode(value="listingContentView")
    private String listingLocalContentView = "local_user_requests_view";

    public String getRequestDocType() {
        return this.requestDocType;
    }

    public String getContainerDocType() {
        return this.containerDocType;
    }

    public String getContainerParentPath() {
        return this.containerParentPath;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getContainerTitle() {
        return this.containerTitle;
    }

    public String getValidationEmailTitle() {
        return this.validationEmailTitle;
    }

    public String getValidationEmailTemplate() {
        return this.validationEmailTemplate;
    }

    public String getSuccessEmailTitle() {
        return this.successEmailTitle;
    }

    public String getSuccessEmailTemplate() {
        return this.successEmailTemplate;
    }

    public Class<? extends InvitationUserFactory> getRegistrationUserFactory() {
        return this.registrationUserFactory;
    }

    public String getValidationRelUrl() {
        if (StringUtils.isBlank((String)this.validationRelUrl)) {
            log.info((Object)("Configuration " + this.name + " has empty validation url"));
            return "";
        }
        return this.validationRelUrl;
    }

    public String getEnterPasswordUrl() {
        if (StringUtils.isBlank((String)this.enterPasswordUrl)) {
            log.info((Object)("Configuration " + this.name + " has empty validation url"));
            return "";
        }
        if (this.enterPasswordUrl.startsWith("/")) {
            this.enterPasswordUrl = this.enterPasswordUrl.substring(1);
        }
        return this.enterPasswordUrl;
    }

    public String getReviveEmailTitle() {
        return this.reviveEmailTitle;
    }

    public String getReviveEmailTemplate() {
        return this.reviveEmailTemplate;
    }

    public String getUserInfoSchemaName() {
        return this.userInfoSchemaName;
    }

    public String getUserInfoUsernameField() {
        return this.userInfoUsernameField;
    }

    public String getUserInfoEmailField() {
        return this.userInfoEmailField;
    }

    public String getUserInfoFirstnameField() {
        return this.userInfoFirstnameField;
    }

    public String getUserInfoLastnameField() {
        return this.userInfoLastnameField;
    }

    public String getUserInfoCompanyField() {
        return this.userInfoCompanyField;
    }

    public String getUserInfoPasswordField() {
        return this.userInfoPasswordField;
    }

    public String getUserInfoGroupsField() {
        return this.userInfoGroupsField;
    }

    public String getUserInfoTenantIdField() {
        return this.userInfoTenantIdField;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public String getInvitationLayout() {
        return this.invitationLayout;
    }

    public void setInvitationLayout(String invitationLayout) {
        this.invitationLayout = invitationLayout;
    }

    public String getListingLocalContentView() {
        return this.listingLocalContentView;
    }

    public void setListingLocalContentView(String listingLocalContentView) {
        this.listingLocalContentView = listingLocalContentView;
    }

    public void mergeWith(UserRegistrationConfiguration other) {
        if (!StringUtils.isEmpty((String)other.requestDocType)) {
            this.requestDocType = other.requestDocType;
        }
        if (!StringUtils.isEmpty((String)other.containerDocType)) {
            this.containerDocType = other.containerDocType;
        }
        if (!StringUtils.isEmpty((String)other.containerParentPath)) {
            this.containerParentPath = other.containerParentPath;
        }
        if (!StringUtils.isEmpty((String)other.containerName)) {
            this.containerName = other.containerName;
        }
        if (!StringUtils.isEmpty((String)other.containerTitle)) {
            this.containerTitle = other.containerTitle;
        }
        if (!StringUtils.isEmpty((String)other.validationEmailTitle)) {
            this.validationEmailTitle = other.validationEmailTitle;
        }
        if (!StringUtils.isEmpty((String)other.validationEmailTemplate)) {
            this.validationEmailTemplate = other.validationEmailTemplate;
        }
        if (!StringUtils.isEmpty((String)other.successEmailTitle)) {
            this.successEmailTitle = other.successEmailTitle;
        }
        if (!StringUtils.isEmpty((String)other.successEmailTemplate)) {
            this.successEmailTemplate = other.successEmailTemplate;
        }
        if (!StringUtils.isEmpty((String)other.reviveEmailTitle)) {
            this.reviveEmailTitle = other.reviveEmailTitle;
        }
        if (!StringUtils.isEmpty((String)other.reviveEmailTemplate)) {
            this.reviveEmailTemplate = other.reviveEmailTemplate;
        }
        if (other.getRegistrationUserFactory() != null) {
            this.registrationUserFactory = other.registrationUserFactory;
        }
        if (!StringUtils.isEmpty((String)other.validationRelUrl)) {
            this.validationRelUrl = other.validationRelUrl;
        }
        if (!StringUtils.isEmpty((String)other.enterPasswordUrl)) {
            this.enterPasswordUrl = other.enterPasswordUrl;
        }
        if (!StringUtils.isEmpty((String)other.invitationLayout)) {
            this.invitationLayout = other.invitationLayout;
        }
        if (!StringUtils.isEmpty((String)other.listingLocalContentView)) {
            this.listingLocalContentView = other.listingLocalContentView;
        }
        if (!StringUtils.isEmpty((String)other.userInfoSchemaName)) {
            this.userInfoSchemaName = other.userInfoSchemaName;
        }
        if (!StringUtils.isEmpty((String)other.userInfoUsernameField)) {
            this.userInfoUsernameField = other.userInfoUsernameField;
        }
        if (!StringUtils.isEmpty((String)other.userInfoFirstnameField)) {
            this.userInfoFirstnameField = other.userInfoFirstnameField;
        }
        if (!StringUtils.isEmpty((String)other.userInfoLastnameField)) {
            this.userInfoLastnameField = other.userInfoLastnameField;
        }
        if (!StringUtils.isEmpty((String)other.userInfoEmailField)) {
            this.userInfoEmailField = other.userInfoEmailField;
        }
        if (!StringUtils.isEmpty((String)other.userInfoPasswordField)) {
            this.userInfoPasswordField = other.userInfoPasswordField;
        }
        if (!StringUtils.isEmpty((String)other.userInfoCompanyField)) {
            this.userInfoCompanyField = other.userInfoCompanyField;
        }
        if (!StringUtils.isEmpty((String)other.userInfoGroupsField)) {
            this.userInfoGroupsField = other.userInfoGroupsField;
        }
        if (!StringUtils.isEmpty((String)other.userInfoTenantIdField)) {
            this.userInfoTenantIdField = other.userInfoTenantIdField;
        }
    }
}

