/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.worker;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.collections.core.worker.RemovedAbstractWork;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

public class RemovedCollectionWork
extends RemovedAbstractWork {
    private static final Log log = LogFactory.getLog(RemovedCollectionWork.class);
    private static final long serialVersionUID = -1771698891732664092L;
    public static final String CATEGORY = "removedCollection";
    protected static final String TITLE = "Removed Collection Work";

    public RemovedCollectionWork() {
    }

    protected RemovedCollectionWork(long offset) {
        super(offset);
    }

    public String getTitle() {
        return TITLE;
    }

    public String getCategory() {
        return CATEGORY;
    }

    @Override
    protected String getQuery() {
        return "SELECT * FROM Document WHERE ecm:isProxy = 0 AND collectionMember:collectionIds/* = ?";
    }

    @Override
    protected void updateDocument(DocumentModel collectionMember) {
        log.trace((Object)String.format("Worker %s, updating CollectionMember %s", this.getId(), collectionMember.getTitle()));
        ((CollectionManager)Framework.getLocalService(CollectionManager.class)).doRemoveFromCollection(collectionMember, this.docId, this.session);
    }
}

