/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.worker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.collections.core.adapter.CollectionMember;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.runtime.api.Framework;

public class DuplicateCollectionMemberWork
extends AbstractWork {
    private static final Log log = LogFactory.getLog(DuplicateCollectionMemberWork.class);
    public static final String CATEGORY = "duplicateCollectionMember";
    protected static final long serialVersionUID = 4985374651436954280L;
    protected static final String TITLE = "Duplicate CollectionMember Work";
    protected String newCollectionId;
    protected List<String> collectionMemberIds;

    public DuplicateCollectionMemberWork(String repoName, String newCollectionId, List<String> collectionMemberIds, int offset) {
        super("duplicateCollectionMember:" + repoName + ":" + newCollectionId + ":" + offset);
        this.repositoryName = repoName;
        this.newCollectionId = newCollectionId;
        this.repositoryName = repoName;
        this.collectionMemberIds = new ArrayList<String>(collectionMemberIds);
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getNewCollectionId() {
        return this.newCollectionId;
    }

    public String getTitle() {
        return TITLE;
    }

    public void setNewCollectionId(String newCollectionId) {
        this.newCollectionId = newCollectionId;
    }

    public void work() {
        this.setStatus("Duplicating");
        if (this.collectionMemberIds != null) {
            CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
            this.setProgress(new Work.Progress(0L, (long)this.collectionMemberIds.size()));
            this.openSystemSession();
            for (int i = 0; i < this.collectionMemberIds.size(); ++i) {
                DocumentModel collectionMember;
                log.trace((Object)String.format("Worker %s, populating Collection %s, processing CollectionMember %s", this.getId(), this.newCollectionId, this.collectionMemberIds.get(i)));
                if (this.collectionMemberIds.get(i) != null && collectionManager.isCollectable(collectionMember = this.session.getDocument((DocumentRef)new IdRef(this.collectionMemberIds.get(i))))) {
                    collectionMember.putContextData("disableDublinCoreListener", (Serializable)Boolean.valueOf(true));
                    collectionMember.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
                    collectionMember.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(true));
                    collectionMember.putContextData("DisableAutoCheckOut", (Serializable)Boolean.valueOf(true));
                    CollectionMember collectionMemberAdapter = (CollectionMember)collectionMember.getAdapter(CollectionMember.class);
                    collectionMemberAdapter.addToCollection(this.newCollectionId);
                    this.session.saveDocument(collectionMember);
                }
                this.setProgress(new Work.Progress((long)i, (long)this.collectionMemberIds.size()));
            }
        }
        this.setStatus("Done");
    }
}

